This is a reference implementation of Architectural Type System Style\
Please use the below as reference and apply to our context

~~~html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superdesign | Join the Private Beta</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&family=Inter+Tight:wght@800;900&family=JetBrains+Mono:wght@500&display=swap" rel="stylesheet">
    <meta name="view-transition" content="same-origin">
    <style>
        @view-transition {
            navigation: auto;
        }
        ::view-transition-old(root),
        ::view-transition-new(root) {
            animation-duration: 0.4s;
            animation-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #000000;
            color: #ffffff;
            margin: 0;
            padding: 0;
        }

        .font-display {
            font-family: 'Inter Tight', sans-serif;
            letter-spacing: -0.06em;
        }

        .font-mono-custom {
            font-family: 'JetBrains Mono', 'Courier New', monospace;
        }

        .noise {
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)'/%3E%3C/svg%3E");
            opacity: 0.05;
            pointer-events: none;
        }

        .hairline { border: 0.5px solid rgba(255, 255, 255, 0.15); }
        .hairline-b { border-bottom: 0.5px solid rgba(255, 255, 255, 0.15); }
        .hairline-r { border-right: 0.5px solid rgba(255, 255, 255, 0.15); }
        .hairline-l { border-left: 0.5px solid rgba(255, 255, 255, 0.15); }
        .hairline-t { border-top: 0.5px solid rgba(255, 255, 255, 0.15); }

        .massive-text {
            line-height: 0.76;
            font-size: clamp(5rem, 24vw, 18vw);
        }

        @media (min-width: 1024px) {
            .massive-text { font-size: 18vw; }
        }

        @media (max-width: 768px) {
            .massive-text { font-size: 24vw; }
        }

        /* Ensure exactly 100vh structure on desktop */
        @media (min-width: 1024px) {
            .desktop-fold-container {
                height: 100vh;
                display: flex;
                flex-direction: column;
            }
            .hero-scaling-grid {
                flex-grow: 1;
            }
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex flex-col items-center relative">
        <!-- Noise Overlay -->
        <div class="fixed inset-0 noise z-0"></div>

        <!-- Hero Wrapper for 100vh desktop experience -->
        <div class="w-full desktop-fold-container">
            <!-- Navigation (Swiss Style) -->
            <nav class="w-full px-6 py-4 flex justify-between items-center z-50 bg-black/80 backdrop-blur-md hairline-b shrink-0">
                <div class="flex items-center gap-6">
                    <button id="nav-menu-btn" class="text-white">
                        <iconify-icon icon="lucide:menu" class="text-3xl"></iconify-icon>
                    </button>
                    <div class="flex items-center gap-2">
                        <span class="font-display font-black text-2xl uppercase tracking-tighter">SUPERDESIGN</span>
                        <span class="w-1.5 h-1.5 bg-white rounded-full mb-1"></span>
                        <span class="font-mono-custom text-[10px] text-white/40 ml-2">BETA_V.01</span>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <a href="#" id="nav-discord" class="w-10 h-10 hairline rounded-full flex items-center justify-center hover:bg-white/10 transition-colors">
                        <iconify-icon icon="mdi:discord" class="text-xl"></iconify-icon>
                    </a>
                    <a href="#" id="cta-nav-access" class="hairline px-6 py-2 rounded-full text-[10px] font-bold tracking-widest hover:bg-white hover:text-black transition-all">
                        GET ACCESS
                    </a>
                </div>
            </nav>

            <!-- Hero Grid Section (Responsive Grid Matrix) -->
            <section class="w-full overflow-hidden hero-scaling-grid flex flex-col">
                <div class="grid grid-cols-2 flex-grow">
                    <div class="hairline-r hairline-b p-4 md:p-8 flex items-end overflow-hidden">
                        <h1 class="massive-text font-display font-black text-white uppercase -ml-[4vw]">SU</h1>
                    </div>
                    <div class="hairline-b p-4 md:p-8 flex items-end overflow-hidden">
                        <h1 class="massive-text font-display font-black text-white uppercase -ml-[2vw]">PER</h1>
                    </div>
                    <div class="hairline-r p-4 md:p-8 flex items-start overflow-hidden">
                        <h1 class="massive-text font-display font-black text-white uppercase -ml-[4vw] -mt-[2vw]">DE</h1>
                    </div>
                    <div class="p-4 md:p-8 flex items-start overflow-hidden">
                        <h1 class="massive-text font-display font-black text-white uppercase -ml-[2vw] -mt-[2vw]">SIGN</h1>
                    </div>
                </div>
            </section>

            <!-- Command Bar (Responsive Layouts) -->
            <section class="w-full grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 hairline-b hairline-t z-10 bg-black shrink-0">
                <!-- Quadrant 1: Input -->
                <div class="hairline-r hairline-b md:hairline-b-0 flex items-center bg-black group">
                    <input 
                        type="email" 
                        placeholder="ENTER_EMAIL" 
                        class="w-full h-full bg-transparent px-8 py-8 md:py-10 text-white focus:outline-none font-mono-custom text-[10px] tracking-[0.2em] uppercase placeholder:text-white/20"
                    >
                </div>
                <!-- Quadrant 2: Button -->
                <div class="lg:hairline-r hairline-b md:hairline-b-0 flex items-center">
                    <button id="cta-join-beta" class="w-full h-full bg-white text-black font-black py-8 md:py-10 text-[11px] tracking-[0.3em] uppercase hover:bg-indigo-600 hover:text-white transition-all duration-300">
                        JOIN BETA
                    </button>
                </div>
                <!-- Quadrant 3: Countdown -->
                <div class="hairline-r flex items-center px-8 py-8 md:py-10 justify-center bg-black">
                    <div id="countdown" class="font-mono-custom text-xl md:text-2xl font-medium tracking-tighter flex items-center gap-1">
                        <span id="hours">12</span>
                        <span class="text-white/20">:</span>
                        <span id="minutes">04</span>
                        <span class="text-white/20">:</span>
                        <span id="seconds">36</span>
                    </div>
                </div>
                <!-- Quadrant 4: FUD Reducers -->
                <div class="flex flex-col justify-center px-8 py-8 md:py-10 gap-1 bg-black">
                    <span class="text-[8px] font-mono-custom text-white/40 uppercase tracking-[0.4em] leading-relaxed">FREE_PRIVATE_ACCESS</span>
                    <span class="text-[8px] font-mono-custom text-white/40 uppercase tracking-[0.4em] leading-relaxed">LIMITED_BETA_COHORT</span>
                    <span class="text-[8px] font-mono-custom text-white/40 uppercase tracking-[0.4em] leading-relaxed">NO_CREDIT_CARD_REQ</span>
                </div>
            </section>
        </div>

        <!-- Content Below the Fold -->
        <!-- Headline & Subheadline Section -->
        <section class="w-full hairline-b grid md:grid-cols-2">
            <div class="hairline-r p-12 md:p-24">
                <h2 class="text-5xl md:text-8xl font-thin tracking-tighter leading-[0.9] text-white/90">
                    STOP<br/>REDESIGNING.<br/><span class="text-white">START SHIPPING.</span>
                </h2>
            </div>
            <div class="p-12 md:p-24 flex flex-col justify-center">
                <p class="text-3xl md:text-5xl font-black leading-tight tracking-tighter uppercase">
                    The design engine for high-output builders. Create production-ready interfaces 10x faster.
                </p>
                <div class="mt-12 flex gap-12">
                    <div class="flex flex-col">
                        <span class="text-[10px] font-mono-custom text-white/40 uppercase tracking-widest mb-2">WAITLISTED</span>
                        <span class="text-4xl font-display font-black">1,248</span>
                    </div>
                    <div class="flex flex-col">
                        <span class="text-[10px] font-mono-custom text-white/40 uppercase tracking-widest mb-2">SPOTS_LEFT</span>
                        <span class="text-4xl font-display font-black text-indigo-500">12</span>
                    </div>
                </div>
            </div>
        </section>

        <!-- Bento Grid Section -->
        <section class="w-full grid md:grid-cols-3">
            <!-- Feature 1 -->
            <div class="hairline-r hairline-b p-8 flex flex-col bg-black hover:bg-white/[0.02] transition-colors group h-[400px]">
                <span class="text-[10px] font-mono-custom text-white/30 mb-8 tracking-widest">SYSTEMS_01</span>
                <div class="flex-grow flex items-center justify-center">
                    <iconify-icon icon="lucide:code" class="text-7xl opacity-20 group-hover:opacity-100 transition-opacity"></iconify-icon>
                </div>
                <div class="mt-auto">
                    <h3 class="text-2xl font-black mb-2 uppercase tracking-tighter">Instant Code</h3>
                    <p class="text-sm text-white/40">React & Tailwind ready export. No handoffs.</p>
                </div>
            </div>

            <!-- Feature 2 -->
            <div class="hairline-r hairline-b p-8 flex flex-col bg-black hover:bg-white/[0.02] transition-colors group h-[400px]">
                <span class="text-[10px] font-mono-custom text-white/30 mb-8 tracking-widest">LOGIC_02</span>
                <div class="flex-grow flex items-center justify-center">
                    <div class="w-32 h-32 hairline rotate-45 group-hover:rotate-90 transition-transform duration-700 flex items-center justify-center">
                         <div class="w-16 h-16 bg-white/10"></div>
                    </div>
                </div>
                <div class="mt-auto">
                    <h3 class="text-2xl font-black mb-2 uppercase tracking-tighter">Brand Aware</h3>
                    <p class="text-sm text-white/40">Design systems respected by default.</p>
                </div>
            </div>

            <!-- Feature 3 -->
            <div class="hairline-b p-8 flex flex-col bg-black hover:bg-white/[0.02] transition-colors group h-[400px]">
                <span class="text-[10px] font-mono-custom text-white/30 mb-8 tracking-widest">INTERFACE_03</span>
                <div class="flex-grow flex items-center justify-center">
                    <div class="w-full max-w-[150px] aspect-video hairline flex items-center justify-center overflow-hidden">
                         <div class="w-full h-[1px] bg-white/20"></div>
                    </div>
                </div>
                <div class="mt-auto">
                    <h3 class="text-2xl font-black mb-2 uppercase tracking-tighter">Precision Canvas</h3>
                    <p class="text-sm text-white/40">The fluidness of Figma, the rigor of code.</p>
                </div>
            </div>
        </section>

        <!-- Social Proof -->
        <section class="w-full grid md:grid-cols-2 hairline-b">
            <div class="p-12 md:p-24 hairline-r">
                <p class="text-2xl font-light text-white/60 italic mb-8">"Finally, a tool that respects how builders actually think."</p>
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-full bg-indigo-600/20 hairline"></div>
                    <div>
                        <div class="font-black uppercase text-xs tracking-widest">SARAH JENKINS</div>
                        <div class="text-[10px] font-mono-custom text-white/30">VERCEL_ENG</div>
                    </div>
                </div>
            </div>
            <div class="p-12 md:p-24">
                <p class="text-2xl font-light text-white/60 italic mb-8">"The level of control is unparalleled. Not just another toy."</p>
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-full bg-white/10 hairline"></div>
                    <div>
                        <div class="font-black uppercase text-xs tracking-widest">MARCUS THORNE</div>
                        <div class="text-[10px] font-mono-custom text-white/30">STRIPE_DSGN</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer class="w-full py-12 px-6 flex flex-col md:flex-row justify-between items-center gap-8 bg-black z-10">
            <div class="flex items-center gap-3">
                <span class="font-display font-black text-lg tracking-tighter">SUPERDESIGN</span>
                <span class="text-[9px] font-mono-custom text-white/20 uppercase">©_2024_LABS</span>
            </div>
            <div class="flex gap-8 text-[10px] font-mono-custom text-white/40 uppercase tracking-widest">
                <a href="#" id="footer-twitter" class="hover:text-white transition-colors">X_COM</a>
                <a href="#" id="footer-discord" class="hover:text-white transition-colors">DISCORD</a>
                <a href="#" id="footer-terms" class="hover:text-white transition-colors">TERMS</a>
            </div>
        </footer>
    </div>

    <script>
        // Countdown Timer Logic
        const timer = {
            hours: 12,
            minutes: 04,
            seconds: 36
        };

        function updateTimer() {
            if (timer.seconds > 0) {
                timer.seconds--;
            } else if (timer.minutes > 0) {
                timer.minutes--;
                timer.seconds = 59;
            } else if (timer.hours > 0) {
                timer.hours--;
                timer.minutes = 59;
                timer.seconds = 59;
            }

            const hEl = document.getElementById('hours');
            const mEl = document.getElementById('minutes');
            const sEl = document.getElementById('seconds');
            
            if(hEl) hEl.innerText = String(timer.hours).padStart(2, '0');
            if(mEl) mEl.innerText = String(timer.minutes).padStart(2, '0');
            if(sEl) sEl.innerText = String(timer.seconds).padStart(2, '0');
        }

        setInterval(updateTimer, 1000);

        // Reveal on scroll logic simplified for Swiss style
        const observerOptions = { threshold: 0.1 };
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('opacity-100');
                    entry.target.classList.remove('opacity-0');
                }
            });
        }, observerOptions);

        // Apply observer only to sections that are likely below the fold initially
        document.querySelectorAll('section:not(.hero-scaling-grid), .hairline:not(nav .hairline)').forEach(el => {
            el.classList.add('transition-opacity', 'duration-1000', 'opacity-0');
            observer.observe(el);
        });
    </script>
</body>
</html>
~~~