This is a reference implementation of a fluid animations, serif typography, and a distinctive curved layout style

~~~html
<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superdesign — Intelligence By Design</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Playfair+Display:ital,wght@0,400..900;1,400..900&family=JetBrains+Mono:ital,wght@0,100..800;1,100..800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-cream: #fcfbf9;
            --bg-dark: #171717;
            --indigo-accent: #4338ca;
            --ease-premium: cubic-bezier(0.22, 1, 0.36, 1);
        }

        body {
            font-family: 'Inter', sans-serif;
        }

        .font-serif {
            font-family: 'Playfair Display', serif;
        }

        .font-mono {
            font-family: 'JetBrains Mono', monospace;
        }

        @keyframes mesh-drift {
            0% { transform: translate(-50%, -50%) rotate(0deg) scale(1.1); }
            50% { transform: translate(-48%, -52%) rotate(180deg) scale(1.2); }
            100% { transform: translate(-50%, -50%) rotate(360deg) scale(1.1); }
        }

        .animate-mesh {
            animation: mesh-drift 30s infinite linear;
        }

        .wave-container {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 25vh;
            z-index: 20;
            overflow: hidden;
        }

        .wave-curve {
            width: 120%;
            height: 200%;
            background-color: var(--bg-cream);
            position: absolute;
            left: -10%;
            top: 20%;
            border-radius: 50% 50% 0 0;
            box-shadow: 0 -20px 60px rgba(0, 0, 0, 0.05);
        }

        .reveal-on-scroll {
            opacity: 0;
            transform: translateY(40px);
            transition: all 1s var(--ease-premium);
        }

        .reveal-on-scroll.visible {
            opacity: 1;
            transform: translateY(0);
        }

        .nav-link {
            position: relative;
        }

        .nav-link::after {
            content: '';
            position: absolute;
            width: 0;
            height: 1px;
            bottom: -4px;
            left: 0;
            background-color: currentColor;
            transition: width 0.4s var(--ease-premium);
        }

        .nav-link:hover::after {
            width: 100%;
        }

        .line-draw {
            position: relative;
        }

        .line-draw::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 1px;
            background-color: #e5e5e5;
            transition: width 1.5s var(--ease-premium);
        }

        .line-draw.visible::after {
            width: 100%;
        }

        @keyframes pulse-gentle {
            0% { transform: scale(1); box-shadow: 0 0 0 0 rgba(67, 56, 202, 0.4); }
            50% { transform: scale(1.02); box-shadow: 0 0 20px 5px rgba(67, 56, 202, 0.2); }
            100% { transform: scale(1); box-shadow: 0 0 0 0 rgba(67, 56, 202, 0.4); }
        }

        .animate-pulse-button {
            animation: pulse-gentle 3s infinite var(--ease-premium);
        }

        .stagger-item {
            transition-delay: calc(var(--stagger) * 0.1s);
        }
    </style>
</head>
<body>
    <div class="min-h-screen bg-[#fcfbf9] text-[#171717] selection:bg-indigo-100 selection:text-indigo-900">
        
        <!-- Header -->
        <header class="fixed top-0 left-0 w-full z-50 mix-blend-difference text-white">
            <div class="max-w-[100rem] mx-auto px-6 md:px-12 py-8 flex justify-between items-center">
                <a id="nav-logo" href="#" class="text-2xl font-serif italic tracking-tight hover:opacity-80 transition-opacity">
                    Superdesign.
                </a>
                
                <nav class="hidden md:flex items-center gap-10 font-mono text-sm uppercase tracking-[0.2em]">
                    <a id="nav-work" href="#work" class="nav-link hover:text-indigo-300 transition-colors">Work</a>
                    <a id="nav-intelligence" href="#intelligence" class="nav-link hover:text-indigo-300 transition-colors">Intelligence</a>
                    <a id="nav-studio" href="#studio" class="nav-link hover:text-indigo-300 transition-colors">Studio</a>
                </nav>

                <div class="flex items-center gap-6">
                    <a id="nav-cta" href="#contact" class="hidden md:flex items-center gap-3 border border-white/30 rounded-full px-6 py-2 font-mono text-[10px] uppercase tracking-widest hover:bg-white hover:text-black transition-all">
                        <span class="relative flex h-2 w-2">
                          <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75"></span>
                          <span class="relative inline-flex rounded-full h-2 w-2 bg-green-500"></span>
                        </span>
                        System Online
                    </a>
                    <button id="nav-menu" class="md:hidden flex flex-col gap-1.5">
                        <span class="w-8 h-0.5 bg-white"></span>
                        <span class="w-8 h-0.5 bg-white"></span>
                    </button>
                </div>
            </div>
        </header>

        <!-- Hero Section -->
        <section class="relative w-full min-h-screen flex flex-col items-center justify-center pt-20 overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute inset-0 z-0 opacity-40">
                <div class="animate-mesh absolute top-1/2 left-1/2 w-[80vw] h-[80vw] bg-indigo-200/50 rounded-full blur-[120px]"></div>
                <div class="absolute top-1/4 left-1/3 w-[40vw] h-[40vw] bg-purple-200/40 rounded-full blur-[100px]"></div>
            </div>

            <!-- Content -->
            <div class="relative z-10 text-center px-6 max-w-7xl mx-auto">
                <div class="mb-8 flex items-center justify-center gap-3 font-mono text-xs md:text-sm text-indigo-600 tracking-[0.3em] uppercase">
                    <iconify-icon icon="lucide:hexagon" class="w-5 h-5"></iconify-icon>
                    <span>Augmented Creativity</span>
                </div>
                
                <h1 class="font-serif text-[14vw] md:text-[11vw] leading-[0.85] tracking-tighter text-[#171717]">
                    Intelligence<br />
                    <span class="italic font-light text-neutral-500 block mt-2">By Design</span>
                </h1>
            </div>

            <!-- The Wave Curve -->
            <div class="wave-container">
                <div class="wave-curve flex items-start justify-center pt-12 md:pt-16">
                    <a id="hero-init-btn" href="#intro" class="group animate-pulse-button relative flex items-center gap-3 px-8 py-4 bg-[#171717] text-white rounded-full hover:bg-indigo-600 transition-all duration-500 shadow-xl hover:shadow-indigo-500/30 hover:-translate-y-1">
                        <span class="font-mono text-xs uppercase tracking-widest">Initialize</span>
                        <iconify-icon icon="lucide:arrow-right" class="w-4 h-4 group-hover:translate-x-1 transition-transform"></iconify-icon>
                    </a>
                </div>
            </div>
        </section>

        <!-- Intro Section -->
        <section id="intro" class="relative z-20 py-32 md:py-48 px-6 bg-[#fcfbf9]">
            <div class="max-w-4xl mx-auto text-center reveal-on-scroll">
                <p class="text-3xl md:text-5xl font-medium leading-[1.2] text-neutral-800">
                    We are an AI-driven product studio crafting <span class="font-serif italic text-indigo-600 underline underline-offset-8 decoration-1">adaptive interfaces</span> for the next generation of intelligent software.
                </p>
                
                <div class="mt-24 flex flex-wrap justify-center gap-12 md:gap-20 text-neutral-300">
                    <iconify-icon icon="lucide:cpu" class="w-14 h-14 hover:text-indigo-400 transition-colors"></iconify-icon>
                    <iconify-icon icon="lucide:zap" class="w-14 h-14 hover:text-indigo-400 transition-colors"></iconify-icon>
                    <iconify-icon icon="lucide:globe" class="w-14 h-14 hover:text-indigo-400 transition-colors"></iconify-icon>
                    <iconify-icon icon="lucide:message-square" class="w-14 h-14 hover:text-indigo-400 transition-colors"></iconify-icon>
                </div>
            </div>
        </section>

        <!-- Work Section -->
        <section id="work" class="relative z-20 py-20 px-6 md:px-12 max-w-[100rem] mx-auto">
            <div class="flex flex-col md:flex-row justify-between items-end mb-24 line-draw pb-10 reveal-on-scroll">
                <h2 class="font-serif text-7xl md:text-9xl text-[#171717]">
                    Selected<br/><span class="italic text-neutral-400">Work</span>
                </h2>
                <span class="hidden md:block font-mono text-sm text-neutral-500 uppercase tracking-[0.4em] mb-4">
                    [ 2023 — 2025 ]
                </span>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-24 md:gap-y-32">
                <!-- Project 1 -->
                <article class="group cursor-pointer reveal-on-scroll">
                    <div class="relative w-full aspect-[4/3] overflow-hidden rounded-2xl bg-indigo-50 transition-transform duration-700 ease-[cubic-bezier(0.22,1,0.36,1)] group-hover:scale-[1.02] group-hover:-translate-y-4 shadow-none group-hover:shadow-2xl group-hover:shadow-indigo-500/10">
                        <div class="absolute inset-0 bg-[#e0e7ff] transition-transform duration-1000 group-hover:scale-110"></div>
                        <div class="absolute inset-0 flex items-center justify-center opacity-30 group-hover:opacity-50 transition-opacity">
                            <div class="w-64 h-64 bg-indigo-700 rounded-full blur-[80px]"></div>
                        </div>
                        <div class="absolute bottom-8 right-8 translate-y-4 opacity-0 group-hover:translate-y-0 group-hover:opacity-100 transition-all duration-500">
                            <span class="flex items-center gap-2 px-6 py-3 bg-white text-[#171717] rounded-full text-xs font-bold uppercase tracking-wider shadow-xl">
                                View Case <iconify-icon icon="lucide:arrow-up-right"></iconify-icon>
                            </span>
                        </div>
                    </div>
                    <div class="mt-6 flex justify-between items-start border-t border-neutral-200 pt-6">
                        <div>
                            <h3 class="text-3xl font-serif font-medium">Neura Finance</h3>
                            <p class="font-mono text-xs text-neutral-500 uppercase mt-2 tracking-widest">Fintech AI Dashboard</p>
                        </div>
                        <span class="font-mono text-xs border border-neutral-300 rounded-full px-4 py-1.5 text-neutral-400">2024</span>
                    </div>
                </article>

                <!-- Project 2 -->
                <article class="group cursor-pointer md:mt-32 reveal-on-scroll">
                    <div class="relative w-full aspect-[4/3] overflow-hidden rounded-2xl bg-emerald-50 transition-transform duration-700 ease-[cubic-bezier(0.22,1,0.36,1)] group-hover:scale-[1.02] group-hover:-translate-y-4 shadow-none group-hover:shadow-2xl group-hover:shadow-emerald-500/10">
                        <div class="absolute inset-0 bg-[#ecfdf5] transition-transform duration-1000 group-hover:scale-110"></div>
                        <div class="absolute inset-0 flex items-center justify-center opacity-30 group-hover:opacity-50 transition-opacity">
                            <div class="w-64 h-64 bg-emerald-600 rounded-full blur-[80px]"></div>
                        </div>
                        <div class="absolute bottom-8 right-8 translate-y-4 opacity-0 group-hover:translate-y-0 group-hover:opacity-100 transition-all duration-500">
                            <span class="flex items-center gap-2 px-6 py-3 bg-white text-[#171717] rounded-full text-xs font-bold uppercase tracking-wider shadow-xl">
                                View Case <iconify-icon icon="lucide:arrow-up-right"></iconify-icon>
                            </span>
                        </div>
                    </div>
                    <div class="mt-6 flex justify-between items-start border-t border-neutral-200 pt-6">
                        <div>
                            <h3 class="text-3xl font-serif font-medium">Cortext</h3>
                            <p class="font-mono text-xs text-neutral-500 uppercase mt-2 tracking-widest">Medical LLM Interface</p>
                        </div>
                        <span class="font-mono text-xs border border-neutral-300 rounded-full px-4 py-1.5 text-neutral-400">2024</span>
                    </div>
                </article>

                <!-- Project 3 -->
                <article class="group cursor-pointer reveal-on-scroll">
                    <div class="relative w-full aspect-[4/3] overflow-hidden rounded-2xl bg-slate-50 transition-transform duration-700 ease-[cubic-bezier(0.22,1,0.36,1)] group-hover:scale-[1.02] group-hover:-translate-y-4 shadow-none group-hover:shadow-2xl group-hover:shadow-slate-500/10">
                        <div class="absolute inset-0 bg-[#f3f4f6] transition-transform duration-1000 group-hover:scale-110"></div>
                        <div class="absolute inset-0 flex items-center justify-center opacity-30 group-hover:opacity-50 transition-opacity">
                            <div class="w-64 h-64 bg-slate-600 rounded-full blur-[80px]"></div>
                        </div>
                        <div class="absolute bottom-8 right-8 translate-y-4 opacity-0 group-hover:translate-y-0 group-hover:opacity-100 transition-all duration-500">
                            <span class="flex items-center gap-2 px-6 py-3 bg-white text-[#171717] rounded-full text-xs font-bold uppercase tracking-wider shadow-xl">
                                View Case <iconify-icon icon="lucide:arrow-up-right"></iconify-icon>
                            </span>
                        </div>
                    </div>
                    <div class="mt-6 flex justify-between items-start border-t border-neutral-200 pt-6">
                        <div>
                            <h3 class="text-3xl font-serif font-medium">Nexus One</h3>
                            <p class="font-mono text-xs text-neutral-500 uppercase mt-2 tracking-widest">Autonomous Logistics</p>
                        </div>
                        <span class="font-mono text-xs border border-neutral-300 rounded-full px-4 py-1.5 text-neutral-400">2023</span>
                    </div>
                </article>

                <!-- Project 4 -->
                <article class="group cursor-pointer md:mt-32 reveal-on-scroll">
                    <div class="relative w-full aspect-[4/3] overflow-hidden rounded-2xl bg-fuchsia-50 transition-transform duration-700 ease-[cubic-bezier(0.22,1,0.36,1)] group-hover:scale-[1.02] group-hover:-translate-y-4 shadow-none group-hover:shadow-2xl group-hover:shadow-fuchsia-500/10">
                        <div class="absolute inset-0 bg-[#fae8ff] transition-transform duration-1000 group-hover:scale-110"></div>
                        <div class="absolute inset-0 flex items-center justify-center opacity-30 group-hover:opacity-50 transition-opacity">
                            <div class="w-64 h-64 bg-fuchsia-600 rounded-full blur-[80px]"></div>
                        </div>
                        <div class="absolute bottom-8 right-8 translate-y-4 opacity-0 group-hover:translate-y-0 group-hover:opacity-100 transition-all duration-500">
                            <span class="flex items-center gap-2 px-6 py-3 bg-white text-[#171717] rounded-full text-xs font-bold uppercase tracking-wider shadow-xl">
                                View Case <iconify-icon icon="lucide:arrow-up-right"></iconify-icon>
                            </span>
                        </div>
                    </div>
                    <div class="mt-6 flex justify-between items-start border-t border-neutral-200 pt-6">
                        <div>
                            <h3 class="text-3xl font-serif font-medium">Aether Gen</h3>
                            <p class="font-mono text-xs text-neutral-500 uppercase mt-2 tracking-widest">Generative Art Platform</p>
                        </div>
                        <span class="font-mono text-xs border border-neutral-300 rounded-full px-4 py-1.5 text-neutral-400">2024</span>
                    </div>
                </article>
            </div>
        </section>

        <!-- Services Section -->
        <section id="intelligence" class="relative z-20 py-32 px-6 md:px-12 bg-neutral-100/50 mt-32">
            <div class="max-w-[100rem] mx-auto grid grid-cols-1 md:grid-cols-12 gap-16 md:gap-24">
                <div class="md:col-span-4">
                    <div class="md:sticky md:top-32 reveal-on-scroll">
                        <h2 class="font-serif text-6xl text-[#171717] leading-none mb-10">
                            Core<br/><span class="italic text-indigo-600">Capabilities</span>
                        </h2>
                        <p class="text-neutral-500 text-lg mb-10 max-w-sm leading-relaxed">
                            Leveraging large language models and generative design patterns to build software that thinks.
                        </p>
                        <a id="service-contact-btn" href="#contact" class="inline-flex items-center gap-3 border-b-2 border-[#171717] pb-1.5 text-xs font-mono uppercase tracking-widest hover:text-indigo-600 hover:border-indigo-600 transition-all">
                            Start a Project <iconify-icon icon="lucide:arrow-right"></iconify-icon>
                        </a>
                    </div>
                </div>

                <div class="md:col-span-8 flex flex-col" x-data="{ active: 0 }">
                    <!-- Service 1 -->
                    <div class="border-b border-neutral-200 py-10 group cursor-pointer reveal-on-scroll stagger-item" style="--stagger: 1" @mouseenter="active = 1">
                        <div class="flex items-center justify-between mb-2">
                            <h3 class="text-3xl md:text-5xl font-serif text-neutral-400 group-hover:text-[#171717] transition-colors duration-300">Generative UI</h3>
                            <div class="w-12 h-12 rounded-full border border-neutral-200 flex items-center justify-center group-hover:bg-[#171717] group-hover:text-white transition-all">
                                <iconify-icon icon="lucide:plus" class="transition-transform" :class="active === 1 ? 'rotate-45' : ''"></iconify-icon>
                            </div>
                        </div>
                        <div class="overflow-hidden transition-all duration-500 max-h-0" :style="active === 1 ? 'max-height: 400px' : ''">
                            <div class="pt-4">
                                <p class="text-lg text-neutral-600 font-light leading-relaxed mb-6 max-w-2xl">
                                    We build adaptive interfaces that evolve based on user intent and context. Moving beyond static screens to fluid, intelligent experiences.
                                </p>
                                <div class="flex flex-wrap gap-2">
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[Dynamic Components]</span>
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[Context-Aware]</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Service 2 -->
                    <div class="border-b border-neutral-200 py-10 group cursor-pointer reveal-on-scroll stagger-item" style="--stagger: 2" @mouseenter="active = 2">
                        <div class="flex items-center justify-between mb-2">
                            <h3 class="text-3xl md:text-5xl font-serif text-neutral-400 group-hover:text-[#171717] transition-colors duration-300">System Architecture</h3>
                            <div class="w-12 h-12 rounded-full border border-neutral-200 flex items-center justify-center group-hover:bg-[#171717] group-hover:text-white transition-all">
                                <iconify-icon icon="lucide:plus" class="transition-transform" :class="active === 2 ? 'rotate-45' : ''"></iconify-icon>
                            </div>
                        </div>
                        <div class="overflow-hidden transition-all duration-500 max-h-0" :style="active === 2 ? 'max-height: 400px' : ''">
                            <div class="pt-4">
                                <p class="text-lg text-neutral-600 font-light leading-relaxed mb-6 max-w-2xl">
                                    Creating robust design systems that scale with AI. We define the tokens, rules, and constraints that allow agents to build consistent UI.
                                </p>
                                <div class="flex flex-wrap gap-2">
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[Tokens]</span>
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[Scalability]</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Service 3 -->
                    <div class="border-b border-neutral-200 py-10 group cursor-pointer reveal-on-scroll stagger-item" style="--stagger: 3" @mouseenter="active = 3">
                        <div class="flex items-center justify-between mb-2">
                            <h3 class="text-3xl md:text-5xl font-serif text-neutral-400 group-hover:text-[#171717] transition-colors duration-300">Neural UX</h3>
                            <div class="w-12 h-12 rounded-full border border-neutral-200 flex items-center justify-center group-hover:bg-[#171717] group-hover:text-white transition-all">
                                <iconify-icon icon="lucide:plus" class="transition-transform" :class="active === 3 ? 'rotate-45' : ''"></iconify-icon>
                            </div>
                        </div>
                        <div class="overflow-hidden transition-all duration-500 max-h-0" :style="active === 3 ? 'max-height: 400px' : ''">
                            <div class="pt-4">
                                <p class="text-lg text-neutral-600 font-light leading-relaxed mb-6 max-w-2xl">
                                    Optimizing the interaction layer between human cognition and artificial intelligence. Making complex models accessible and intuitive.
                                </p>
                                <div class="flex flex-wrap gap-2">
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[HCI]</span>
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[Prompting]</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Service 4 -->
                    <div class="border-b border-neutral-200 py-10 group cursor-pointer reveal-on-scroll stagger-item" style="--stagger: 4" @mouseenter="active = 4">
                        <div class="flex items-center justify-between mb-2">
                            <h3 class="text-3xl md:text-5xl font-serif text-neutral-400 group-hover:text-[#171717] transition-colors duration-300">Product Strategy</h3>
                            <div class="w-12 h-12 rounded-full border border-neutral-200 flex items-center justify-center group-hover:bg-[#171717] group-hover:text-white transition-all">
                                <iconify-icon icon="lucide:plus" class="transition-transform" :class="active === 4 ? 'rotate-45' : ''"></iconify-icon>
                            </div>
                        </div>
                        <div class="overflow-hidden transition-all duration-500 max-h-0" :style="active === 4 ? 'max-height: 400px' : ''">
                            <div class="pt-4">
                                <p class="text-lg text-neutral-600 font-light leading-relaxed mb-6 max-w-2xl">
                                    Defining the role of AI in your product lifecycle. From feature discovery to deployment, we map the path to intelligent utility.
                                </p>
                                <div class="flex flex-wrap gap-2">
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[Roadmap]</span>
                                    <span class="text-[10px] font-mono font-bold text-indigo-600 uppercase tracking-widest bg-indigo-50 px-3 py-1.5 rounded">[Product-Fit]</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer id="contact" class="relative z-30 bg-[#171717] text-[#fcfbf9] pt-32 pb-16 px-6 md:px-12 mt-32 rounded-t-[3rem] md:rounded-t-[5rem] overflow-hidden">
            <!-- Background Accent -->
            <div class="absolute top-0 left-0 w-full h-full bg-[radial-gradient(circle_at_50%_0%,#312e81,transparent_50%)] opacity-30"></div>
            
            <div class="relative max-w-[100rem] mx-auto flex flex-col items-center text-center">
                <div class="mb-20 opacity-40">
                    <iconify-icon icon="lucide:hexagon" class="w-24 h-24 text-indigo-400 animate-[spin_20s_linear_infinite] opacity-50"></iconify-icon>
                </div>

                <h2 class="font-serif text-[10vw] md:text-[8vw] leading-[0.9] text-white mb-20 reveal-on-scroll">
                    "The future is not <br/><span class="italic text-indigo-400">written</span>, it is <span class="italic text-indigo-400">generated</span>."
                </h2>

                <div class="w-full h-px bg-white/10 max-w-4xl mx-auto mb-20"></div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-16 md:gap-32 mb-32 w-full max-w-6xl">
                    <div class="text-center reveal-on-scroll">
                        <h4 class="font-mono text-[10px] uppercase tracking-[0.4em] text-white/40 mb-6">Location</h4>
                        <p class="text-xl md:text-2xl font-light">San Francisco, CA</p>
                    </div>
                    <div class="text-center reveal-on-scroll" style="transition-delay: 100ms">
                        <h4 class="font-mono text-[10px] uppercase tracking-[0.4em] text-white/40 mb-6">Inquiries</h4>
                        <a id="footer-email" href="mailto:hello@superdesign.ai" class="text-xl md:text-2xl font-light hover:text-indigo-400 transition-colors">hello@superdesign.ai</a>
                    </div>
                    <div class="text-center reveal-on-scroll" style="transition-delay: 200ms">
                        <h4 class="font-mono text-[10px] uppercase tracking-[0.4em] text-white/40 mb-6">Social</h4>
                        <div class="flex justify-center gap-6">
                            <a id="footer-twitter" href="#" class="text-lg font-light hover:text-indigo-400 transition-colors">Twitter</a>
                            <a id="footer-linkedin" href="#" class="text-lg font-light hover:text-indigo-400 transition-colors">LinkedIn</a>
                            <a id="footer-github" href="#" class="text-lg font-light hover:text-indigo-400 transition-colors">GitHub</a>
                        </div>
                    </div>
                </div>

                <div class="flex flex-col items-center gap-4 opacity-50">
                    <span class="font-serif italic text-3xl">Superdesign.</span>
                    <span class="font-mono text-[9px] uppercase tracking-[0.5em]">© 2025 Intelligence Systems Inc. — All Rights Reserved.</span>
                </div>
            </div>
        </footer>

    </div>

    <script>
        // Intersection Observer for scroll animations
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('visible');
                }
            });
        }, observerOptions);

        // Parallax Effect for Hero Mesh
        const mesh1 = document.querySelector('.animate-mesh');
        const mesh2 = document.querySelector('.absolute.top-1\\/4.left-1\\/3');
        
        window.addEventListener('scroll', () => {
            const scrolled = window.pageYOffset;
            if (scrolled < window.innerHeight) {
                if (mesh1) mesh1.style.transform = `translate(-50%, calc(-50% + ${scrolled * 0.1}px))`;
                if (mesh2) mesh2.style.transform = `translateY(${scrolled * -0.05}px)`;
            }
        });

        document.querySelectorAll('.reveal-on-scroll').forEach(el => {
            observer.observe(el);
        });

        // Header scroll effect
        let lastScroll = 0;
        const header = document.querySelector('header');
        
        window.addEventListener('scroll', () => {
            const currentScroll = window.pageYOffset;
            if (currentScroll <= 0) {
                header.classList.remove('-translate-y-full');
                return;
            }
            
            if (currentScroll > lastScroll) {
                // scroll down
                header.classList.add('-translate-y-full');
            } else {
                // scroll up
                header.classList.remove('-translate-y-full');
            }
            header.style.transition = 'transform 0.4s cubic-bezier(0.22, 1, 0.36, 1)';
            lastScroll = currentScroll;
        });
    </script>
</body>
</html>
~~~

Please use the above as reference and apply to our context