This is a reference implementation of kinetic orange style

~~~html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superdesign® — Brutalist Portfolio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Archivo+Black&family=Inter:wght@400;700&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --brand-orange: #FF4D00;
        }
        body {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            background-color: var(--brand-orange);
        }
        .font-serif-bold {
            font-family: 'Archivo Black', sans-serif;
            letter-spacing: -0.04em;
            line-height: 0.9;
        }
        .font-mono-custom {
            font-family: 'Space Mono', monospace;
            letter-spacing: -0.02em;
        }
        @keyframes marquee {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }
        .animate-marquee {
            display: flex;
            width: 200%;
            animation: marquee 30s linear infinite;
        }
        .animate-marquee-reverse {
            display: flex;
            width: 200%;
            animation: marquee 35s linear infinite reverse;
        }
        .animate-spin-slow {
            animation: spin 12s linear infinite;
        }
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        .service-card:hover .arrow-reveal {
            opacity: 1;
            transform: rotate(45deg) translateX(10px);
        }
        .skew-marquee {
            transform: skewY(-2deg);
        }
        selection {
            background: black;
            color: var(--brand-orange);
        }
        ::-moz-selection {
            background: black;
            color: var(--brand-orange);
        }
    </style>
</head>
<body>
    <div class="min-h-screen bg-[#FF4D00] text-black overflow-x-hidden">
        
        <!-- Navigation -->
        <nav class="fixed top-0 left-0 right-0 z-50 px-4 md:px-12 py-6 flex items-center justify-between pointer-events-none">
            <div class="pointer-events-auto">
                <a href="#" id="nav-logo-link" class="font-serif-bold text-xl md:text-2xl uppercase tracking-tighter">Superdesign®</a>
            </div>
            
            <div class="hidden md:flex items-center gap-1 bg-black rounded-full p-1 border border-white/10 pointer-events-auto shadow-2xl">
                <a href="#work" id="nav-work-link" class="px-6 py-2 rounded-full text-white text-xs font-mono-custom uppercase hover:bg-white hover:text-black transition-all duration-300">Work</a>
                <a href="#services" id="nav-services-link" class="px-6 py-2 rounded-full text-white text-xs font-mono-custom uppercase hover:bg-white hover:text-black transition-all duration-300">Services</a>
                <a href="#about" id="nav-about-link" class="px-6 py-2 rounded-full text-white text-xs font-mono-custom uppercase hover:bg-white hover:text-black transition-all duration-300">About</a>
                <a href="#contact" id="nav-contact-link" class="px-6 py-2 rounded-full text-white text-xs font-mono-custom uppercase hover:bg-white hover:text-black transition-all duration-300">Contact</a>
            </div>

            <div class="flex items-center gap-3 pointer-events-auto">
                <a href="#" id="nav-twitter-link" class="w-10 h-10 rounded-full border-2 border-black flex items-center justify-center hover:bg-black hover:text-[#FF4D00] transition-colors">
                    <iconify-icon icon="lucide:twitter" class="text-xl"></iconify-icon>
                </a>
                <a href="#" id="nav-instagram-link" class="w-10 h-10 rounded-full border-2 border-black flex items-center justify-center hover:bg-black hover:text-[#FF4D00] transition-colors">
                    <iconify-icon icon="lucide:instagram" class="text-xl"></iconify-icon>
                </a>
            </div>
        </nav>

        <!-- Hero Section -->
        <header class="relative min-h-screen flex flex-col justify-center pt-24 pb-12 px-4">
            <div class="container mx-auto">
                <div class="flex flex-col items-center justify-center text-center">
                    <h1 class="font-serif-bold text-[16vw] leading-[0.85] uppercase tracking-tighter mb-12">
                        Super<br/>Design
                    </h1>
                </div>
                
                <div class="mt-12 border-t-2 border-black pt-6 flex flex-col md:flex-row justify-between items-center gap-8">
                    <div class="flex items-center gap-3 font-mono-custom text-sm font-bold uppercase tracking-wider">
                        <iconify-icon icon="lucide:globe" class="text-xl"></iconify-icon>
                        <span>Based in Digital Void</span>
                    </div>

                    <!-- Rotating Scroll Indicator -->
                    <div class="relative w-28 h-28 md:w-36 md:h-36 flex items-center justify-center">
                        <div class="absolute inset-0 animate-spin-slow">
                            <svg viewBox="0 0 100 100" class="w-full h-full fill-black">
                                <path id="textPath" d="M 50 50 m -37 0 a 37 37 0 1 1 74 0 a 37 37 0 1 1 -74 0" fill="none" />
                                <text class="text-[9px] font-mono-custom font-bold tracking-[0.2em] uppercase">
                                    <textPath href="#textPath">Scroll Down • Scroll Down • Scroll Down • </textPath>
                                </text>
                            </svg>
                        </div>
                        <iconify-icon icon="lucide:arrow-down" class="text-3xl md:text-4xl"></iconify-icon>
                    </div>

                    <div class="text-right font-mono-custom text-sm font-bold uppercase tracking-wider leading-relaxed">
                        AI Product Designer<br/>Since 2024
                    </div>
                </div>
            </div>
        </header>

        <!-- Marquee Section -->
        <section class="bg-black py-12 md:py-20 -mx-4 skew-marquee origin-left overflow-hidden">
            <div class="animate-marquee whitespace-nowrap flex gap-12 text-[#FF4D00]">
                <span class="font-serif-bold text-[10vw] uppercase">Strategy • Design • AI • Strategy • Design • AI • Strategy • Design • AI •</span>
                <span class="font-serif-bold text-[10vw] uppercase">Strategy • Design • AI • Strategy • Design • AI • Strategy • Design • AI •</span>
            </div>
            <div class="animate-marquee-reverse whitespace-nowrap flex gap-12 text-white opacity-80 mt-[-2vw]">
                <span class="font-serif-bold text-[10vw] uppercase">Code • Future • Create • Code • Future • Create • Code • Future • Create •</span>
                <span class="font-serif-bold text-[10vw] uppercase">Code • Future • Create • Code • Future • Create • Code • Future • Create •</span>
            </div>
        </section>

        <!-- Services Section -->
        <section id="services" class="bg-black text-white py-32 md:py-48 px-4">
            <div class="container mx-auto">
                <div class="flex items-end justify-between mb-24">
                    <h2 class="font-serif-bold text-[10vw] leading-none uppercase">Services</h2>
                    <iconify-icon icon="lucide:star" class="text-[#FF4D00] text-7xl md:text-[8vw] hidden sm:block animate-pulse"></iconify-icon>
                </div>

                <div class="flex flex-col">
                    <!-- Service Item 01 -->
                    <div class="service-card group border-t border-white/20 py-12 md:py-16 hover:bg-white/5 transition-colors cursor-pointer">
                        <div class="flex flex-col md:flex-row md:items-start gap-6 md:gap-12">
                            <span class="font-mono-custom text-[#FF4D00] text-xl font-bold">(01)</span>
                            <div class="flex-grow">
                                <h3 class="font-serif-bold text-5xl md:text-[7vw] leading-none uppercase group-hover:translate-x-4 transition-transform duration-500">AI Strategy</h3>
                                <div class="flex gap-3 mt-6">
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">Consulting</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">Implementation</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">LLM Integration</span>
                                </div>
                            </div>
                            <iconify-icon icon="lucide:arrow-up-right" class="arrow-reveal opacity-0 text-[10vw] text-[#FF4D00] transition-all duration-500 hidden md:block"></iconify-icon>
                        </div>
                    </div>

                    <!-- Service Item 02 -->
                    <div class="service-card group border-t border-white/20 py-12 md:py-16 hover:bg-white/5 transition-colors cursor-pointer">
                        <div class="flex flex-col md:flex-row md:items-start gap-6 md:gap-12">
                            <span class="font-mono-custom text-[#FF4D00] text-xl font-bold">(02)</span>
                            <div class="flex-grow">
                                <h3 class="font-serif-bold text-5xl md:text-[7vw] leading-none uppercase group-hover:translate-x-4 transition-transform duration-500">Interface</h3>
                                <div class="flex gap-3 mt-6">
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">UI/UX Design</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">Design Systems</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">Prototyping</span>
                                </div>
                            </div>
                            <iconify-icon icon="lucide:arrow-up-right" class="arrow-reveal opacity-0 text-[10vw] text-[#FF4D00] transition-all duration-500 hidden md:block"></iconify-icon>
                        </div>
                    </div>

                    <!-- Service Item 03 -->
                    <div class="service-card group border-t border-white/20 py-12 md:py-16 hover:bg-white/5 transition-colors cursor-pointer">
                        <div class="flex flex-col md:flex-row md:items-start gap-6 md:gap-12">
                            <span class="font-mono-custom text-[#FF4D00] text-xl font-bold">(03)</span>
                            <div class="flex-grow">
                                <h3 class="font-serif-bold text-5xl md:text-[7vw] leading-none uppercase group-hover:translate-x-4 transition-transform duration-500">Development</h3>
                                <div class="flex gap-3 mt-6">
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">React</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">TypeScript</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">Next.js</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">WebGL</span>
                                </div>
                            </div>
                            <iconify-icon icon="lucide:arrow-up-right" class="arrow-reveal opacity-0 text-[10vw] text-[#FF4D00] transition-all duration-500 hidden md:block"></iconify-icon>
                        </div>
                    </div>

                    <!-- Service Item 04 -->
                    <div class="service-card group border-t border-b border-white/20 py-12 md:py-16 hover:bg-white/5 transition-colors cursor-pointer">
                        <div class="flex flex-col md:flex-row md:items-start gap-6 md:gap-12">
                            <span class="font-mono-custom text-[#FF4D00] text-xl font-bold">(04)</span>
                            <div class="flex-grow">
                                <h3 class="font-serif-bold text-5xl md:text-[7vw] leading-none uppercase group-hover:translate-x-4 transition-transform duration-500">Branding</h3>
                                <div class="flex gap-3 mt-6">
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">Identity</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">Motion</span>
                                    <span class="border border-white/40 px-3 py-1 rounded-full font-mono-custom text-[10px] uppercase tracking-wider">3D Visuals</span>
                                </div>
                            </div>
                            <iconify-icon icon="lucide:arrow-up-right" class="arrow-reveal opacity-0 text-[10vw] text-[#FF4D00] transition-all duration-500 hidden md:block"></iconify-icon>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section id="contact" class="bg-[#FF4D00] py-40 px-4 flex flex-col items-center text-center">
            <div class="container mx-auto">
                <h2 class="font-serif-bold text-[12vw] md:text-[14vw] leading-none uppercase mb-16">
                    Let's Talk
                </h2>
                <a href="mailto:hello@superdesign.ai" id="cta-email-btn" class="inline-block px-12 py-6 bg-black text-white text-xl md:text-2xl font-mono-custom font-bold uppercase rounded-full hover:scale-110 transition-transform duration-300 shadow-2xl">
                    hello@superdesign.ai
                </a>
            </div>
        </section>

        <!-- Footer -->
        <footer class="bg-[#FF4D00] py-12 px-4 md:px-12 border-t-2 border-black">
            <div class="container mx-auto flex flex-col md:flex-row justify-between items-center gap-8">
                <p class="font-mono-custom text-xs font-bold uppercase">© 2024 Superdesign Inc.</p>
                <div class="flex gap-6 md:gap-12 flex-wrap justify-center">
                    <a href="#" id="footer-instagram-link" class="font-mono-custom text-xs font-bold uppercase hover:underline decoration-2">Instagram</a>
                    <a href="#" id="footer-twitter-link" class="font-mono-custom text-xs font-bold uppercase hover:underline decoration-2">Twitter</a>
                    <a href="#" id="footer-linkedin-link" class="font-mono-custom text-xs font-bold uppercase hover:underline decoration-2">LinkedIn</a>
                    <a href="#" id="footer-github-link" class="font-mono-custom text-xs font-bold uppercase hover:underline decoration-2">Github</a>
                </div>
            </div>
        </footer>

    </div>

    <script>
        // Subtle reveal animation for scroll
        document.addEventListener('DOMContentLoaded', () => {
            const observerOptions = {
                threshold: 0.1
            };

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('opacity-100', 'translate-y-0');
                        entry.target.classList.remove('opacity-0', 'translate-y-10');
                    }
                });
            }, observerOptions);

            document.querySelectorAll('.service-card').forEach(card => {
                card.classList.add('opacity-0', 'translate-y-10', 'transition-all', 'duration-700');
                observer.observe(card);
            });
        });
    </script>
</body>
</html>
~~~

Please use the above as reference and apply to our context