This is a reference implementation of Bold Editorial Studio Style

~~~html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superdesign® — Creative Studio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', -apple-system, sans-serif;
            cursor: none; /* Hide default cursor */
        }

        @keyframes slideUp {
            from {
                transform: translateY(100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .animate-reveal span {
            display: inline-block;
            transform: translateY(100%);
            opacity: 0;
            animation: slideUp 1s cubic-bezier(0.16, 1, 0.3, 1) forwards;
        }

        @keyframes marquee {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }

        .animate-marquee {
            animation: marquee 30s linear infinite;
        }

        .marquee-container:hover .animate-marquee {
            animation-play-state: paused;
        }

        .custom-cursor {
            pointer-events: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 32px;
            height: 32px;
            border: 1px solid black;
            border-radius: 50%;
            z-index: 9999;
            mix-blend-mode: difference;
            background-color: white;
            transition: transform 0.3s cubic-bezier(0.23, 1, 0.32, 1);
            transform: translate(-50%, -50%);
        }

        .cursor-active {
            transform: translate(-50%, -50%) scale(2.5);
        }

        /* Custom Selection Colors */
        ::selection {
            background: black;
            color: white;
        }
    </style>
</head>
<body>
    <div id="root" class="min-h-screen bg-white text-black selection:bg-black selection:text-white">
        
        <!-- Custom Cursor -->
        <div id="cursor" class="custom-cursor"></div>

        <!-- Header -->
        <header class="fixed top-0 left-0 right-0 z-50 flex items-center justify-between px-6 py-6 mix-blend-difference text-white pointer-events-none">
            <div class="text-2xl font-bold tracking-tighter pointer-events-auto cursor-pointer">
                <a href="#" id="logo-link">sd</a>
            </div>
            <button class="p-2 hover:opacity-70 transition-opacity pointer-events-auto cursor-pointer" id="nav-toggle-btn">
                <iconify-icon icon="lucide:plus" class="text-3xl"></iconify-icon>
            </button>
        </header>

        <main>
            <!-- Hero Section -->
            <section class="relative min-h-[80vh] flex flex-col items-center justify-center pt-20">
                <div class="w-full px-4 text-center">
                    <h1 class="text-[12vw] leading-none font-bold tracking-tighter mb-4 select-none flex justify-center overflow-hidden py-[2vw] animate-reveal">
                        <span style="animation-delay: 0.1s">S</span>
                        <span style="animation-delay: 0.16s">u</span>
                        <span style="animation-delay: 0.22s">p</span>
                        <span style="animation-delay: 0.28s">e</span>
                        <span style="animation-delay: 0.34s">r</span>
                        <span style="animation-delay: 0.40s">d</span>
                        <span style="animation-delay: 0.46s">e</span>
                        <span style="animation-delay: 0.52s">s</span>
                        <span style="animation-delay: 0.58s">i</span>
                        <span style="animation-delay: 0.64s">g</span>
                        <span style="animation-delay: 0.70s">n</span>
                        <span class="text-2xl align-top ml-2 font-normal mt-[2vw]" style="animation-delay: 0.76s">®</span>
                    </h1>
                    
                    <div class="opacity-0 translate-y-4 animate-fade-in-up" style="animation: slideUp 0.8s 1s ease-out forwards">
                        <p class="text-xl md:text-2xl text-neutral-600 font-medium tracking-tight mt-8">
                            Creative studio based in Tokyo.
                        </p>
                    </div>
                </div>
            </section>

            <!-- Project Slider Marquee -->
            <section class="py-12 bg-white overflow-hidden cursor-scale">
                <div class="marquee-container w-full overflow-hidden">
                    <div class="flex gap-4 md:gap-8 animate-marquee w-max">
                        <!-- Project Images Repeated for Loop -->
                        <!-- First Set -->
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tl-[100px]">
                            <img src="https://images.unsplash.com/photo-1600607686527-6fb886090705?q=80&w=2700&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tr-[100px] rounded-bl-[40px]">
                            <img src="https://images.unsplash.com/photo-1618005182384-a83a8bd57fbe?q=80&w=2564&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-[40px]">
                            <img src="https://images.unsplash.com/photo-1550684848-fac1c5b4e853?q=80&w=2670&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tl-[100px]">
                            <img src="https://images.unsplash.com/photo-1614850523459-c2f4c699c52e?q=80&w=2670&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tr-[100px] rounded-bl-[40px]">
                            <img src="https://images.unsplash.com/photo-1634152962476-4b8a00e1915c?q=80&w=2500&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-[40px]">
                            <img src="https://images.unsplash.com/photo-1558655146-d09347e92766?q=80&w=2500&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <!-- Duplicate for infinite scroll -->
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tl-[100px]">
                            <img src="https://images.unsplash.com/photo-1600607686527-6fb886090705?q=80&w=2700&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tr-[100px] rounded-bl-[40px]">
                            <img src="https://images.unsplash.com/photo-1618005182384-a83a8bd57fbe?q=80&w=2564&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-[40px]">
                            <img src="https://images.unsplash.com/photo-1550684848-fac1c5b4e853?q=80&w=2670&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tl-[100px]">
                            <img src="https://images.unsplash.com/photo-1614850523459-c2f4c699c52e?q=80&w=2670&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-tr-[100px] rounded-bl-[40px]">
                            <img src="https://images.unsplash.com/photo-1634152962476-4b8a00e1915c?q=80&w=2500&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                        <div class="relative flex-shrink-0 w-[280px] h-[400px] md:w-[400px] md:h-[560px] overflow-hidden rounded-[40px]">
                            <img src="https://images.unsplash.com/photo-1558655146-d09347e92766?q=80&w=2500&auto=format&fit=crop" class="w-full h-full object-cover grayscale hover:grayscale-0 transition-all duration-700 hover:scale-105" alt="Work">
                        </div>
                    </div>
                </div>
            </section>

            <!-- Intro Section -->
            <section class="py-24 px-6 md:px-12 bg-white">
                <div class="max-w-5xl mx-auto text-center mb-24">
                    <h2 class="text-3xl md:text-5xl lg:text-6xl font-medium leading-[1.1] tracking-tight">
                        We're Superdesign® — a creative studio cultivating bold brands, beautiful websites, and ideas that refuse to be ordinary.
                    </h2>
                </div>

                <div class="flex flex-wrap justify-center gap-12 md:gap-24 opacity-60 grayscale hover:grayscale-0 transition-all duration-500">
                    <div class="flex items-center gap-2 text-xl font-medium text-neutral-500 hover:text-black transition-colors">
                        <iconify-icon icon="lucide:circle" class="w-6 h-6"></iconify-icon>
                        <span>Blob</span>
                    </div>
                    <div class="flex items-center gap-2 text-xl font-medium text-neutral-500 hover:text-black transition-colors">
                        <iconify-icon icon="lucide:hexagon" class="w-6 h-6"></iconify-icon>
                        <span>Yallo!</span>
                    </div>
                    <div class="flex items-center gap-2 text-xl font-medium text-neutral-500 hover:text-black transition-colors">
                        <iconify-icon icon="lucide:square" class="w-6 h-6"></iconify-icon>
                        <span>Bliss+</span>
                    </div>
                    <div class="flex items-center gap-2 text-xl font-medium text-neutral-500 hover:text-black transition-colors">
                        <iconify-icon icon="lucide:triangle" class="w-6 h-6"></iconify-icon>
                        <span>Flea</span>
                    </div>
                </div>
            </section>

            <!-- Project Grid -->
            <section class="py-24 px-6 md:px-12 bg-white">
                <div class="flex items-end justify-between mb-16 border-b border-black/10 pb-8">
                    <h2 class="text-5xl md:text-7xl font-medium tracking-tighter">
                        Latest <br/> Projects.
                    </h2>
                    <span class="hidden md:block font-mono text-sm uppercase tracking-widest opacity-40">( _04 )</span>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-20">
                    <!-- Project 1 -->
                    <div class="group cursor-pointer">
                        <div class="relative aspect-[4/3] overflow-hidden bg-neutral-100 rounded-sm mb-6">
                            <img src="https://images.unsplash.com/photo-1547891654-e66ed7ebb968?q=80&w=2670&auto=format&fit=crop" class="w-full h-full object-cover transition-transform duration-700 ease-out group-hover:scale-105" alt="Neo Tokyo Art Fair">
                            <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors duration-500"></div>
                            <div class="absolute top-4 right-4 bg-white rounded-full p-2 opacity-0 -translate-y-2 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                                <iconify-icon icon="lucide:arrow-up-right" class="text-xl"></iconify-icon>
                            </div>
                        </div>
                        <div class="flex justify-between items-start border-t border-black/10 pt-4">
                            <div>
                                <h3 class="text-2xl font-medium tracking-tight mb-1">Neo Tokyo Art Fair</h3>
                                <p class="text-neutral-500">Branding</p>
                            </div>
                            <span class="font-mono text-sm text-neutral-400">2024</span>
                        </div>
                    </div>
                    <!-- Project 2 -->
                    <div class="group cursor-pointer">
                        <div class="relative aspect-[4/3] overflow-hidden bg-neutral-100 rounded-sm mb-6">
                            <img src="https://images.unsplash.com/photo-1515462277126-2dd0c162007a?q=80&w=2576&auto=format&fit=crop" class="w-full h-full object-cover transition-transform duration-700 ease-out group-hover:scale-105" alt="Cyber Zen Garden">
                            <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors duration-500"></div>
                            <div class="absolute top-4 right-4 bg-white rounded-full p-2 opacity-0 -translate-y-2 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                                <iconify-icon icon="lucide:arrow-up-right" class="text-xl"></iconify-icon>
                            </div>
                        </div>
                        <div class="flex justify-between items-start border-t border-black/10 pt-4">
                            <div>
                                <h3 class="text-2xl font-medium tracking-tight mb-1">Cyber Zen Garden</h3>
                                <p class="text-neutral-500">Web Design</p>
                            </div>
                            <span class="font-mono text-sm text-neutral-400">2023</span>
                        </div>
                    </div>
                    <!-- Project 3 -->
                    <div class="group cursor-pointer">
                        <div class="relative aspect-[4/3] overflow-hidden bg-neutral-100 rounded-sm mb-6">
                            <img src="https://images.unsplash.com/photo-1561070791-2526d30994b5?q=80&w=2000&auto=format&fit=crop" class="w-full h-full object-cover transition-transform duration-700 ease-out group-hover:scale-105" alt="Type Foundry X">
                            <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors duration-500"></div>
                            <div class="absolute top-4 right-4 bg-white rounded-full p-2 opacity-0 -translate-y-2 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                                <iconify-icon icon="lucide:arrow-up-right" class="text-xl"></iconify-icon>
                            </div>
                        </div>
                        <div class="flex justify-between items-start border-t border-black/10 pt-4">
                            <div>
                                <h3 class="text-2xl font-medium tracking-tight mb-1">Type Foundry X</h3>
                                <p class="text-neutral-500">Typography</p>
                            </div>
                            <span class="font-mono text-sm text-neutral-400">2023</span>
                        </div>
                    </div>
                    <!-- Project 4 -->
                    <div class="group cursor-pointer">
                        <div class="relative aspect-[4/3] overflow-hidden bg-neutral-100 rounded-sm mb-6">
                            <img src="https://images.unsplash.com/photo-1495474472287-4d71bcdd2085?q=80&w=2670&auto=format&fit=crop" class="w-full h-full object-cover transition-transform duration-700 ease-out group-hover:scale-105" alt="Mono Coffee">
                            <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors duration-500"></div>
                            <div class="absolute top-4 right-4 bg-white rounded-full p-2 opacity-0 -translate-y-2 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                                <iconify-icon icon="lucide:arrow-up-right" class="text-xl"></iconify-icon>
                            </div>
                        </div>
                        <div class="flex justify-between items-start border-t border-black/10 pt-4">
                            <div>
                                <h3 class="text-2xl font-medium tracking-tight mb-1">Mono Coffee</h3>
                                <p class="text-neutral-500">Packaging</p>
                            </div>
                            <span class="font-mono text-sm text-neutral-400">2023</span>
                        </div>
                    </div>
                </div>
            </section>
        </main>

        <!-- Footer -->
        <footer class="py-12 px-6 md:px-12 bg-neutral-950 text-white">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-24">
                <div class="col-span-1 md:col-span-2">
                    <h2 class="text-4xl font-bold tracking-tighter mb-8">Superdesign®</h2>
                    <p class="max-w-md text-neutral-400">
                        A digital design studio crafting experiences for the modern web. 
                        Based in Tokyo, working globally.
                    </p>
                </div>
                
                <div>
                    <h4 class="font-mono text-sm text-neutral-500 mb-6 uppercase tracking-wider">Socials</h4>
                    <ul class="space-y-4">
                        <li><a href="#" id="social-ig" class="hover:text-neutral-300 transition-colors">Instagram</a></li>
                        <li><a href="#" id="social-tw" class="hover:text-neutral-300 transition-colors">Twitter</a></li>
                        <li><a href="#" id="social-li" class="hover:text-neutral-300 transition-colors">LinkedIn</a></li>
                        <li><a href="#" id="social-dr" class="hover:text-neutral-300 transition-colors">Dribbble</a></li>
                    </ul>
                </div>
                
                <div>
                    <h4 class="font-mono text-sm text-neutral-500 mb-6 uppercase tracking-wider">Contact</h4>
                    <ul class="space-y-4">
                        <li><a href="mailto:hello@super.design" id="contact-email" class="hover:text-neutral-300 transition-colors">hello@super.design</a></li>
                        <li><a href="tel:+81312345678" id="contact-phone" class="hover:text-neutral-300 transition-colors">+81 3 1234 5678</a></li>
                    </ul>
                </div>
            </div>
            
            <div class="flex flex-col md:flex-row justify-between items-center pt-8 border-t border-white/10 text-sm text-neutral-600">
                <p>© 2024 Superdesign Studio. All rights reserved.</p>
                <p class="mt-4 md:mt-0">Designed & Built with ❤️</p>
            </div>
        </footer>

    </div>

    <script>
        // Custom Cursor Logic
        const cursor = document.getElementById('cursor');
        let mouseX = 0, mouseY = 0;
        let cursorX = 0, cursorY = 0;

        document.addEventListener('mousemove', (e) => {
            mouseX = e.clientX;
            mouseY = e.clientY;
            
            // Check for hover on interactive elements
            const target = e.target;
            if (target.closest('a') || target.closest('button') || target.classList.contains('cursor-pointer') || target.tagName === 'IMG') {
                cursor.classList.add('cursor-active');
            } else {
                cursor.classList.remove('cursor-active');
            }
        });

        // Smooth interpolation for cursor
        function animateCursor() {
            let dx = mouseX - cursorX;
            let dy = mouseY - cursorY;
            
            cursorX += dx * 0.2;
            cursorY += dy * 0.2;
            
            cursor.style.left = cursorX + 'px';
            cursor.style.top = cursorY + 'px';
            
            requestAnimationFrame(animateCursor);
        }
        animateCursor();
    </script>
</body>
</html>
~~~

Please use the above as reference and apply to our context