This is a reference implementation of a Neon Velocity Countdown page

Please use the above as reference and apply to our context

~~~html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superdesign | Join the Private Beta</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,800;1,800&family=Geist+Mono:wght@100..900&family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <meta name="view-transition" content="same-origin">
    <style>
        @view-transition {
            navigation: auto;
        }

        :root {
            --navy-black: #050505;
            --laser-green: #BFFF00;
            --hero-tilt: 15deg;
            --fluid-headline: clamp(2.6rem, 10vw, 8.75rem);
            --fluid-h2: clamp(2rem, 6vw, 5rem);
        }

        @media (max-width: 768px) {
            :root {
                --hero-tilt: 5deg;
            }
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--navy-black);
            color: #ffffff;
            overflow-x: hidden;
            margin: 0;
        }

        .font-header {
            font-family: 'Plus Jakarta Sans', sans-serif;
            letter-spacing: -0.05em;
            font-weight: 800;
        }

        .font-mono {
            font-family: 'Geist Mono', monospace;
        }

        .laser-btn {
            background: var(--laser-green);
            color: #000;
            box-shadow: 0 0 20px rgba(191, 255, 0, 0.3);
            position: relative;
            overflow: hidden;
            min-height: 48px; /* Ensure touch target */
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .laser-btn::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(transparent, rgba(255, 255, 255, 0.4), transparent);
            transform: rotate(45deg);
            transition: 0.6s;
            pointer-events: none;
        }

        .laser-btn:hover::after {
            left: 100%;
        }

        .noise {
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)'/%3E%3C/svg%3E");
            opacity: 0.03;
            pointer-events: none;
        }

        .glass-3d {
            background: rgba(255, 255, 255, 0.01);
            backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.08);
            transform: perspective(1000px) rotateX(var(--hero-tilt)) translateY(-20px);
            box-shadow: 0 40px 100px -20px rgba(191, 255, 0, 0.1), inset 0 0 40px rgba(255, 255, 255, 0.02);
        }

        .luminosity-card {
            background: radial-gradient(circle at top left, rgba(255, 255, 255, 0.03), transparent);
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.5s ease;
        }

        .luminosity-card:hover {
            border-color: rgba(191, 255, 0, 0.3);
            background: radial-gradient(circle at top left, rgba(191, 255, 0, 0.05), transparent);
        }

        .text-fluid-hero {
            font-size: var(--fluid-headline);
        }

        .text-fluid-h2 {
            font-size: var(--fluid-h2);
        }

        .refraction-glow {
            filter: blur(80px);
            background: radial-gradient(circle, rgba(191, 255, 0, 0.15) 0%, transparent 70%);
        }

        /* Mobile Nav Glass */
        .mobile-nav-pill {
            background: rgba(10, 10, 10, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 10px 30px rgba(0,0,0,0.5);
        }

        @view-transition {
            navigation: auto;
        }
        ::view-transition-old(root) {
            animation: 0.4s cubic-bezier(0.4, 0, 0.2, 1) both fade-out;
        }
        ::view-transition-new(root) {
            animation: 0.4s cubic-bezier(0.4, 0, 0.2, 1) both fade-in;
        }
        @keyframes fade-out { from { opacity: 1; } to { opacity: 0; } }
        @keyframes fade-in { from { opacity: 0; } to { opacity: 1; } }
    </style>
</head>
<body>
    <div class="min-h-screen relative flex flex-col items-center overflow-x-hidden">
        <div class="noise fixed inset-0 z-0"></div>
        
        <!-- Global Glows -->
        <div class="refraction-glow absolute top-0 left-1/2 -translate-x-1/2 w-[120vw] h-[600px] -z-10"></div>

        <!-- Responsive Navigation -->
        <nav class="w-full max-w-[1600px] px-6 md:px-12 py-6 md:py-10 flex justify-between items-center z-50">
            <div class="flex items-center gap-2">
                <span class="font-header text-lg md:text-2xl tracking-tighter uppercase">SUPERDESIGN</span>
            </div>
            <!-- Desktop Nav -->
            <div class="hidden md:flex items-center gap-6 lg:gap-10">
                <a id="nav-features" href="#" class="font-mono text-[10px] uppercase tracking-[0.3em] text-white/40 hover:text-white transition-colors">Features</a>
                <a id="nav-contact" href="#" class="px-6 py-2 border border-white/10 hover:bg-white/5 rounded-full text-[10px] font-mono uppercase tracking-[0.2em] transition-all">Contact</a>
                <a id="nav-cta" href="#" class="px-8 py-2.5 laser-btn rounded-full text-[10px] font-mono font-bold uppercase tracking-[0.2em]">Join Beta</a>
            </div>
            <!-- Mobile Menu Toggle (simplified for layout) -->
            <div class="md:hidden">
                <button class="p-3 text-white">
                    <iconify-icon icon="lucide:menu" class="text-2xl"></iconify-icon>
                </button>
            </div>
        </nav>

        <!-- Mobile Bottom Glass Nav -->
        <div class="fixed bottom-6 left-1/2 -translate-x-1/2 z-[100] md:hidden w-[90%] max-w-[400px]">
            <div class="mobile-nav-pill px-6 py-4 rounded-full flex justify-around items-center">
                <a id="mob-home" href="#" class="p-2 text-white/50 hover:text-[#BFFF00] transition-colors"><iconify-icon icon="lucide:home" class="text-xl"></iconify-icon></a>
                <a id="mob-features" href="#" class="p-2 text-white/50 hover:text-[#BFFF00] transition-colors"><iconify-icon icon="lucide:layers" class="text-xl"></iconify-icon></a>
                <a id="mob-cta" href="#" class="px-6 py-2 laser-btn rounded-full text-[9px] font-mono font-bold uppercase tracking-widest">Beta</a>
                <a id="mob-contact" href="#" class="p-2 text-white/50 hover:text-[#BFFF00] transition-colors"><iconify-icon icon="lucide:mail" class="text-xl"></iconify-icon></a>
            </div>
        </div>

        <!-- Hero Section -->
        <main class="w-full max-w-[1600px] px-6 md:px-12 py-12 md:py-24 flex flex-col items-center relative z-10">
            
            <!-- Responsive 3D Glass Dashboard -->
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[90%] md:w-full max-w-5xl h-[300px] md:h-[500px] glass-3d rounded-[24px] md:rounded-[40px] -z-10"></div>

            <!-- Fluid Headline in Border Box -->
            <div class="w-full max-w-5xl border-[6px] md:border-[12px] border-white py-8 md:py-16 px-4 md:px-12 mb-12 md:mb-20">
                <h1 class="text-fluid-hero font-header leading-[0.85] md:leading-[0.8] text-center uppercase">
                    Stop Re-<br/>Designing
                </h1>
            </div>

            <!-- Responsive Metadata Row -->
            <div class="w-full flex flex-col lg:flex-row justify-between items-start lg:items-center gap-10 md:gap-16 mb-20 md:mb-24">
                <div class="flex flex-col gap-4 max-w-3xl">
                    <span class="flex items-center gap-2 text-[#BFFF00] font-mono text-[10px] md:text-xs uppercase tracking-[0.2em]">
                        <iconify-icon icon="lucide:map-pin" class="text-xs"></iconify-icon>
                        DIGITAL HQ / GLOBAL ACCESS
                    </span>
                    <h2 class="text-xl md:text-4xl font-header leading-tight text-white/95 uppercase">
                        The next generation of design engines for builders who want to ship at the speed of light.
                    </h2>
                </div>

                <!-- Countdown -->
                <div class="flex flex-col items-start lg:items-end w-full lg:w-auto">
                    <span class="font-mono text-[10px] uppercase tracking-[0.3em] text-[#BFFF00]/60 mb-2">Invites In:</span>
                    <div id="countdown" class="font-header text-5xl md:text-8xl tabular-nums tracking-tighter">
                        <span id="hours">12</span>.<span id="minutes">03</span>.<span id="seconds">41</span>
                    </div>
                    <span class="font-mono text-[8px] md:text-[9px] uppercase tracking-[0.5em] text-white/20 mt-1">Hours . Mins . Secs</span>
                </div>
            </div>

            <!-- Hero Form -->
            <div class="w-full max-w-2xl flex flex-col gap-8">
                <!-- Social Proof Stack -->
                <div class="flex flex-col items-center gap-5">
                    <div class="flex items-center">
                        <div class="flex -space-x-3 pr-4">
                            <img src="https://images.unsplash.com/photo-1534528741775-53994a69daeb?q=80&w=100&h=100&auto=format&fit=crop" class="w-10 h-10 rounded-full border-2 border-[#BFFF00] shadow-[0_0_15px_rgba(191,255,0,0.4)] object-cover z-[5]" alt="Designer">
                            <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?q=80&w=100&h=100&auto=format&fit=crop" class="w-10 h-10 rounded-full border-2 border-[#BFFF00] shadow-[0_0_15px_rgba(191,255,0,0.4)] object-cover z-[4]" alt="Designer">
                            <img src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?q=80&w=100&h=100&auto=format&fit=crop" class="w-10 h-10 rounded-full border-2 border-[#BFFF00] shadow-[0_0_15px_rgba(191,255,0,0.4)] object-cover z-[3]" alt="Designer">
                            <img src="https://images.unsplash.com/photo-1500648767791-00dcc994a43e?q=80&w=100&h=100&auto=format&fit=crop" class="w-10 h-10 rounded-full border-2 border-[#BFFF00] shadow-[0_0_15px_rgba(191,255,0,0.4)] object-cover z-[2]" alt="Designer">
                            <img src="https://images.unsplash.com/photo-1539571696357-5a69c17a67c6?q=80&w=100&h=100&auto=format&fit=crop" class="w-10 h-10 rounded-full border-2 border-[#BFFF00] shadow-[0_0_15px_rgba(191,255,0,0.4)] object-cover z-[1]" alt="Designer">
                        </div>
                        <div class="px-4 py-2 bg-white/[0.05] backdrop-blur-xl border border-white/10 rounded-full">
                            <span class="font-mono text-[10px] text-white/80 uppercase tracking-[0.2em] whitespace-nowrap">+2k designers joined</span>
                        </div>
                    </div>
                </div>
                <form class="flex flex-col sm:flex-row gap-3 p-2 bg-white/5 backdrop-blur-md rounded-2xl sm:rounded-full border border-white/10">
                    <input 
                        type="email" 
                        placeholder="YOUR@EMAIL.COM" 
                        class="bg-transparent border-none focus:ring-0 px-6 py-4 text-white flex-grow font-mono text-xs placeholder:text-white/20 uppercase tracking-widest min-h-[50px]"
                        required
                    >
                    <button id="cta-hero-submit" class="laser-btn font-mono font-bold px-10 py-4 rounded-xl sm:rounded-full uppercase tracking-[0.2em] text-[10px]">
                        Claim Spot
                    </button>
                </form>
                <div class="flex flex-wrap justify-center gap-4 md:gap-10 font-mono text-[8px] md:text-[10px] uppercase tracking-[0.3em] text-white/30">
                    <span class="hover:text-white transition-colors cursor-default">Free Access</span>
                    <span class="hover:text-white transition-colors cursor-default">Limited Spots</span>
                    <span class="hover:text-white transition-colors cursor-default">No CC Required</span>
                </div>
            </div>
        </main>

        <!-- Responsive Bento Grid Section -->
        <section class="w-full py-24 md:py-48 border-t border-white/5 z-10">
            <div class="max-w-[1600px] mx-auto px-6 md:px-12">
                <div class="flex flex-col lg:flex-row lg:items-end justify-between mb-16 md:mb-32 gap-8">
                    <div class="max-w-3xl">
                        <span class="font-mono text-[10px] uppercase tracking-[0.5em] text-[#BFFF00] block mb-6">02 / PRODUCT ETHOS</span>
                        <h2 class="text-fluid-h2 font-header leading-none uppercase">Stop Fighting<br/>Friction.</h2>
                    </div>
                    <p class="text-white/40 font-mono text-[10px] md:text-xs uppercase tracking-widest leading-relaxed max-w-xs">
                        Built for builders who value velocity over bureaucracy.
                    </p>
                </div>

                <!-- Responsive Bento Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                    <div class="p-8 md:p-12 luminosity-card rounded-[2rem] flex flex-col min-h-[350px] md:min-h-[450px]">
                        <span class="font-mono text-xs text-[#BFFF00] mb-auto">01 / EFFICIENCY</span>
                        <h3 class="text-2xl md:text-4xl font-header mb-6 uppercase leading-none">Instant<br/>Code</h3>
                        <p class="text-white/50 text-xs md:text-sm leading-relaxed font-light uppercase tracking-wide">Export production-ready code instantly. No translation layers. Pure execution from day one.</p>
                    </div>
                    <div class="p-8 md:p-12 luminosity-card rounded-[2rem] flex flex-col min-h-[350px] md:min-h-[450px]">
                        <span class="font-mono text-xs text-[#BFFF00] mb-auto">02 / INTELLIGENCE</span>
                        <h3 class="text-2xl md:text-4xl font-header mb-6 uppercase leading-none">Smart<br/>Systems</h3>
                        <p class="text-white/50 text-xs md:text-sm leading-relaxed font-light uppercase tracking-wide">Quality-first AI that follows your exact brand constraints. Precise generation, zero hallucinations.</p>
                    </div>
                    <div class="p-8 md:p-12 luminosity-card rounded-[2rem] flex flex-col min-h-[350px] md:min-h-[450px] md:col-span-2 lg:col-span-1">
                        <span class="font-mono text-xs text-[#BFFF00] mb-auto">03 / PRECISION</span>
                        <h3 class="text-2xl md:text-4xl font-header mb-6 uppercase leading-none">Spatial<br/>Canvas</h3>
                        <p class="text-white/50 text-xs md:text-sm leading-relaxed font-light uppercase tracking-wide">The precision of an IDE with the fluidity of a design tool. Minimalist and infinitely powerful.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Phase Perks -->
        <section class="w-full pb-24 md:pb-48 z-10">
            <div class="max-w-[1600px] mx-auto px-6 md:px-12">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <div class="md:col-span-2 luminosity-card p-8 md:p-12 rounded-[2rem] flex flex-col justify-between group">
                        <div>
                            <h4 class="font-header text-3xl md:text-6xl mb-8 uppercase leading-none">Early Access<br/><span class="text-[#BFFF00]">Benefit</span></h4>
                            <p class="text-white/40 max-w-sm text-sm md:text-base">Secure your spot months before the public release and define the tool's future alongside our founders.</p>
                        </div>
                        <span class="font-mono text-[10px] uppercase tracking-widest text-[#BFFF00] mt-12 md:mt-24">Phase 01 / Priority Queue</span>
                    </div>
                    <div class="luminosity-card p-8 md:p-12 rounded-[2rem] flex flex-col justify-between">
                        <h4 class="font-header text-xl md:text-2xl uppercase">Founder Circle</h4>
                        <p class="text-white/30 text-xs md:text-sm font-light leading-relaxed">Direct access to the core engineering team and private Discord.</p>
                    </div>
                    <div class="luminosity-card p-8 md:p-12 rounded-[2rem] flex flex-col justify-between">
                        <h4 class="font-header text-xl md:text-2xl uppercase">Lifetime Perks</h4>
                        <p class="text-white/30 text-xs md:text-sm font-light leading-relaxed">Exclusive beta pricing locked in forever for all future updates.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Testimonials -->
        <section class="w-full py-24 md:py-48 border-y border-white/5 z-10 overflow-hidden relative">
            <div class="max-w-[1600px] mx-auto px-6 md:px-12">
                <h2 class="text-fluid-h2 font-header mb-16 md:mb-32 uppercase text-center tracking-tighter">Testimonials of Velocity</h2>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 md:gap-24">
                    <div class="space-y-8 md:space-y-12 relative">
                        <iconify-icon icon="mdi:format-quote-open" class="text-6xl text-[#BFFF00]/10 absolute -top-8 -left-4 md:-left-8"></iconify-icon>
                        <p class="text-xl md:text-4xl font-header text-white leading-tight uppercase">
                            "Finally, a tool that respects how builders actually think. It doesn't just make things look good; it makes them work."
                        </p>
                        <div class="flex items-center gap-6">
                            <div class="w-12 h-12 md:w-16 md:h-16 rounded-full bg-gradient-to-br from-[#BFFF00] to-transparent p-[1px] shadow-[0_0_20px_rgba(191,255,0,0.15)]">
                                <div class="w-full h-full rounded-full bg-[#050505] overflow-hidden">
                                    <img src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?q=80&w=200&h=200&auto=format&fit=crop" class="w-full h-full object-cover" alt="Sarah Jenkins">
                                </div>
                            </div>
                            <div>
                                <div class="font-header text-sm md:text-xl uppercase">Sarah Jenkins</div>
                                <div class="font-mono text-[9px] md:text-[10px] text-[#BFFF00] uppercase tracking-widest">Vercel / Engineer</div>
                            </div>
                        </div>
                    </div>
                    <div class="space-y-8 md:space-y-12">
                        <p class="text-xl md:text-4xl font-header text-white leading-tight uppercase">
                            "I've tried every AI design tool out there. This is the first one that doesn't feel like a toy. Unparalleled control."
                        </p>
                        <div class="flex items-center gap-6">
                            <div class="w-12 h-12 md:w-16 md:h-16 rounded-full bg-gradient-to-br from-[#BFFF00] to-transparent p-[1px] shadow-[0_0_20px_rgba(191,255,0,0.15)]">
                                <div class="w-full h-full rounded-full bg-[#050505] overflow-hidden">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?q=80&w=200&h=200&auto=format&fit=crop" class="w-full h-full object-cover" alt="Marcus Thorne">
                                </div>
                            </div>
                            <div>
                                <div class="font-header text-sm md:text-xl uppercase">Marcus Thorne</div>
                                <div class="font-mono text-[9px] md:text-[10px] text-[#BFFF00] uppercase tracking-widest">Stripe / Designer</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Final CTA -->
        <section class="w-full py-32 md:py-64 px-6 md:px-12 text-center z-10 relative">
            <div class="refraction-glow absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[80vw] h-[80vw] max-w-[800px] opacity-40"></div>
            <div class="max-w-5xl mx-auto flex flex-col items-center space-y-10 md:space-y-16 relative">
                <h2 class="text-5xl md:text-[9rem] font-header tracking-tighter uppercase leading-none">Join the <span class="text-[#BFFF00]">Elite.</span></h2>
                <p class="font-mono text-[10px] md:text-xs text-white/50 uppercase tracking-[0.4em]">Only 12 spots left in this cohort</p>
                <form class="w-full max-w-2xl flex flex-col sm:flex-row gap-3 p-2 bg-white/5 backdrop-blur-md rounded-2xl sm:rounded-full border border-white/10">
                    <input 
                        type="email" 
                        placeholder="Enter your email" 
                        class="bg-transparent border-none focus:ring-0 px-6 py-4 text-white flex-grow font-mono text-xs uppercase tracking-widest"
                    >
                    <button id="cta-final-submit" class="laser-btn font-mono font-bold px-10 py-4 rounded-xl sm:rounded-full uppercase tracking-[0.2em] text-[10px]">
                        Join Waitlist
                    </button>
                </form>
            </div>
        </section>

        <!-- Footer -->
        <footer class="w-full py-12 md:py-20 px-6 md:px-12 border-t border-white/5 flex flex-col md:flex-row justify-between items-center gap-10 md:gap-16 z-10 bg-[#050505] mb-24 md:mb-0">
            <div class="flex items-center gap-2">
                <span class="font-header font-bold text-sm tracking-widest uppercase">SUPERDESIGN &reg;</span>
            </div>
            <div class="font-mono text-[8px] md:text-[10px] text-white/20 uppercase tracking-[0.4em] max-w-xl text-center">
                &copy; 2024 Superdesign Labs. Built for the high-output builder.
            </div>
            <div class="flex gap-10 font-mono text-[9px] md:text-[10px] uppercase tracking-[0.4em]">
                <a id="footer-twitter" href="#" class="text-white/30 hover:text-[#BFFF00] transition-colors">Twitter</a>
                <a id="footer-github" href="#" class="text-white/30 hover:text-[#BFFF00] transition-colors">Github</a>
            </div>
        </footer>

    </div>

    <script>
        // Countdown Timer
        const timer = { hours: 12, minutes: 3, seconds: 41 };
        function updateTimer() {
            if (timer.seconds > 0) timer.seconds--;
            else if (timer.minutes > 0) { timer.minutes--; timer.seconds = 59; }
            else if (timer.hours > 0) { timer.hours--; timer.minutes = 59; timer.seconds = 59; }
            document.getElementById('hours').innerText = String(timer.hours).padStart(2, '0');
            document.getElementById('minutes').innerText = String(timer.minutes).padStart(2, '0');
            document.getElementById('seconds').innerText = String(timer.seconds).padStart(2, '0');
        }
        setInterval(updateTimer, 1000);

        // Reveal on scroll
        const observerOptions = { threshold: 0.05 };
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        document.querySelectorAll('section, .luminosity-card, .glass-3d').forEach(el => {
            el.style.transition = 'all 1.2s cubic-bezier(0.16, 1, 0.3, 1)';
            el.style.opacity = '0';
            el.style.transform = 'translateY(40px)';
            observer.observe(el);
        });
    </script>
</body>
</html>
~~~