This is a reference implementation of a Coral and Ink colors style

~~~html
<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Superdesign — AI Product Design Tool</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Instrument+Serif:ital@0;1&family=Manrope:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#EF4623', // Coral
                        ink: '#2D3B42',     // Ink
                        accent: '#FDF1EE',  // Soft Peach
                        background: '#FFFFFF',
                        foreground: '#2D3B42'
                    },
                    fontFamily: {
                        serif: ['"Instrument Serif"', 'serif'],
                        sans: ['Manrope', 'sans-serif'],
                    },
                    animation: {
                        'fade-up': 'fadeUp 0.8s cubic-bezier(0.16, 1, 0.3, 1) forwards',
                        'fade-in': 'fadeIn 1s ease-out forwards',
                        'bounce-subtle': 'bounceSubtle 3s infinite',
                    },
                    keyframes: {
                        fadeUp: {
                            '0%': { opacity: '0', transform: 'translateY(40px) rotate(2deg)' },
                            '100%': { opacity: '1', transform: 'translateY(0) rotate(0deg)' },
                        },
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        bounceSubtle: {
                            '0%, 100%': { transform: 'translateY(-5%)', 'animation-timing-function': 'cubic-bezier(0.8,0,1,1)' },
                            '50%': { transform: 'none', 'animation-timing-function': 'cubic-bezier(0,0,0.2,1)' },
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .reveal-on-scroll {
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.8s cubic-bezier(0.16, 1, 0.3, 1);
        }
        .reveal-on-scroll.is-visible {
            opacity: 1;
            transform: translateY(0);
        }
        .stagger-1 { transition-delay: 100ms; }
        .stagger-2 { transition-delay: 200ms; }
        .stagger-3 { transition-delay: 300ms; }
        
        .glass-nav {
            transition: all 0.3s ease;
        }
        .glass-nav.scrolled {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(45, 59, 66, 0.05);
            padding-top: 1rem;
            padding-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="min-h-screen bg-background text-foreground font-sans selection:bg-primary selection:text-white overflow-x-hidden">
        
        <!-- Navigation -->
        <nav id="main-nav" class="fixed top-0 left-0 right-0 z-50 px-6 py-6 glass-nav">
            <div class="max-w-7xl mx-auto flex items-center justify-between">
                <a href="#" id="nav-logo" class="flex items-center gap-2 group">
                    <div class="w-9 h-9 bg-primary rounded-lg rotate-3 group-hover:rotate-12 transition-transform duration-300 flex items-center justify-center text-white font-serif italic font-bold text-xl shadow-lg shadow-primary/20">
                        S
                    </div>
                    <span class="font-serif text-2xl font-bold tracking-tight text-ink">Superdesign</span>
                </a>

                <div class="hidden md:flex items-center gap-10 font-sans text-sm font-semibold text-ink/80">
                    <a href="#manifesto" id="nav-link-manifesto" class="hover:text-primary transition-colors">Manifesto</a>
                    <a href="#workflow" id="nav-link-workflow" class="hover:text-primary transition-colors">Workflow</a>
                    <a href="#services" id="nav-link-services" class="hover:text-primary transition-colors">Services</a>
                    <a href="#" id="nav-cta-btn" class="inline-flex items-center justify-center px-6 py-2.5 rounded-full bg-primary text-white text-xs font-bold uppercase tracking-wider hover:bg-ink transition-all duration-300 shadow-lg shadow-primary/10">
                        Start Project
                    </a>
                </div>

                <button id="mobile-menu-toggle" class="md:hidden text-ink p-2">
                    <iconify-icon icon="lucide:menu" class="text-2xl"></iconify-icon>
                </button>
            </div>
        </nav>

        <!-- Hero Section -->
        <section class="relative min-h-screen flex flex-col items-center justify-center pt-32 pb-20 px-6 overflow-hidden">
            <!-- Ambient Background Blur -->
            <div class="absolute top-1/4 -right-20 w-[600px] h-[600px] bg-accent/60 rounded-full blur-[120px] -z-10 animate-pulse"></div>
            <div class="absolute bottom-10 -left-20 w-[500px] h-[500px] bg-primary/10 rounded-full blur-[100px] -z-10"></div>

            <div class="max-w-5xl mx-auto text-center space-y-10 relative z-10">
                <div class="animate-fade-in">
                    <span class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-accent text-primary text-[10px] font-black uppercase tracking-[0.2em] border border-primary/10">
                        <iconify-icon icon="lucide:sparkles" class="text-xs"></iconify-icon>
                        The Future of Design
                    </span>
                </div>

                <h1 class="flex flex-col items-center gap-1 md:gap-4">
                    <span class="font-serif text-6xl md:text-8xl lg:text-[10rem] text-ink leading-[0.85] tracking-tight opacity-0 animate-fade-up">
                        Design at the
                    </span>
                    <span class="font-serif italic text-6xl md:text-8xl lg:text-[10rem] text-primary leading-[0.85] tracking-tight opacity-0 animate-fade-up" style="animation-delay: 0.15s">
                        Speed of Thought
                    </span>
                </h1>

                <p class="font-sans text-lg md:text-2xl text-ink/70 max-w-2xl mx-auto leading-relaxed animate-fade-in" style="animation-delay: 0.5s">
                    Superdesign is your AI-powered creative partner. We bridge the gap between abstract ideas and production-ready interfaces.
                </p>

                <div class="flex flex-col sm:flex-row gap-4 justify-center pt-8 animate-fade-in" style="animation-delay: 0.7s">
                    <a href="#" id="hero-cta-primary" class="group inline-flex items-center justify-center gap-3 px-10 py-5 rounded-full bg-primary text-white font-bold text-lg hover:bg-ink transition-all duration-300 active:scale-95 shadow-2xl shadow-primary/30">
                        Start Designing
                        <iconify-icon icon="lucide:arrow-right" class="group-hover:translate-x-1 transition-transform"></iconify-icon>
                    </a>
                    <a href="#" id="hero-cta-secondary" class="inline-flex items-center justify-center gap-3 px-10 py-5 rounded-full border-2 border-ink/10 text-ink font-bold text-lg hover:border-primary hover:text-primary transition-all duration-300">
                        <iconify-icon icon="lucide:play-circle" class="text-2xl"></iconify-icon>
                        Watch Demo
                    </a>
                </div>
            </div>

            <div class="absolute bottom-12 left-1/2 -translate-x-1/2 animate-bounce-subtle">
                <iconify-icon icon="lucide:chevron-down" class="text-ink/30 text-3xl"></iconify-icon>
            </div>
        </section>

        <!-- Value Prop Section -->
        <section id="manifesto" class="py-32 px-6 relative bg-white border-y border-ink/5">
            <div class="max-w-7xl mx-auto grid lg:grid-cols-2 gap-20 items-center">
                <div class="space-y-12 reveal-on-scroll">
                    <h2 class="font-serif text-5xl md:text-7xl text-ink leading-[1.05] tracking-tight">
                        Stop wireframing. <br />
                        <span class="italic text-primary">Start building.</span>
                    </h2>
                    
                    <div class="space-y-10">
                        <div class="flex gap-6 items-start">
                            <div class="w-14 h-14 rounded-2xl bg-accent flex items-center justify-center shrink-0 text-primary shadow-inner">
                                <iconify-icon icon="lucide:layers" class="text-2xl"></iconify-icon>
                            </div>
                            <div>
                                <h3 class="font-serif text-2xl text-ink mb-3">Context-Aware Design</h3>
                                <p class="text-ink/60 text-lg leading-relaxed">Most AI generates generic layouts. Superdesign understands your brand guidelines, existing components, and user intent to create contextually relevant UIs.</p>
                            </div>
                        </div>
                        
                        <div class="flex gap-6 items-start">
                            <div class="w-14 h-14 rounded-2xl bg-ink flex items-center justify-center shrink-0 text-white">
                                <iconify-icon icon="lucide:zap" class="text-2xl text-primary"></iconify-icon>
                            </div>
                            <div>
                                <h3 class="font-serif text-2xl text-ink mb-3">Production Code, Instantly</h3>
                                <p class="text-ink/60 text-lg leading-relaxed">Don't waste time translating Figma to React. We generate clean, accessible, responsive code that you can copy-paste directly into your codebase.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="relative reveal-on-scroll stagger-2">
                    <div class="absolute -inset-10 bg-gradient-to-tr from-primary/10 to-accent/20 rounded-[4rem] blur-3xl opacity-50"></div>
                    <div class="relative bg-ink rounded-[2.5rem] border border-white/10 p-1 shadow-[0_50px_100px_-20px_rgba(45,59,66,0.3)] overflow-hidden">
                        <!-- UI Mockup Simulator -->
                        <div class="bg-white rounded-[2.2rem] min-h-[540px] flex flex-col">
                            <div class="flex items-center gap-2 px-8 py-6 border-b border-ink/5">
                                <div class="w-3 h-3 rounded-full bg-[#FF5F57]"></div>
                                <div class="w-3 h-3 rounded-full bg-[#FFBC2E]"></div>
                                <div class="w-3 h-3 rounded-full bg-[#28C840]"></div>
                                <div class="ml-4 h-4 w-32 bg-ink/5 rounded-full"></div>
                            </div>
                            
                            <div class="p-8 flex-1 space-y-8">
                                <div class="space-y-4">
                                    <div class="h-4 w-1/4 bg-ink/10 rounded-full"></div>
                                    <div class="h-12 w-3/4 bg-primary/5 border border-primary/10 rounded-xl"></div>
                                </div>
                                <div class="grid grid-cols-2 gap-4">
                                    <div class="h-40 bg-accent/40 rounded-3xl border border-primary/5"></div>
                                    <div class="h-40 bg-ink/5 rounded-3xl"></div>
                                </div>
                                <div class="space-y-4">
                                    <div class="h-4 w-1/2 bg-ink/10 rounded-full"></div>
                                    <div class="h-24 bg-ink/5 rounded-3xl"></div>
                                </div>
                            </div>

                            <div class="p-6 bg-white/90 backdrop-blur-md border-t border-ink/5">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-full bg-green-50 flex items-center justify-center text-green-600">
                                            <iconify-icon icon="lucide:check-circle"></iconify-icon>
                                        </div>
                                        <span class="text-sm font-bold text-ink">Code Generated in 0.4s</span>
                                    </div>
                                    <div class="flex gap-2">
                                        <div class="px-3 py-1 bg-ink text-white rounded-md text-[10px] font-mono">React</div>
                                        <div class="px-3 py-1 bg-ink/5 text-ink rounded-md text-[10px] font-mono">Tailwind</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Features Grid -->
        <section id="workflow" class="py-32 px-6 bg-accent/30">
            <div class="max-w-7xl mx-auto">
                <div class="text-center max-w-3xl mx-auto mb-20 space-y-6 reveal-on-scroll">
                    <span class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-white text-primary text-[10px] font-black uppercase tracking-widest border border-ink/5">The Workflow</span>
                    <h2 class="font-serif text-5xl md:text-6xl text-ink leading-tight">Your new creative superpower</h2>
                    <p class="text-ink/60 text-xl">Designed for product teams who want to move fast without breaking things.</p>
                </div>

                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <!-- Feature 1 Large -->
                    <div class="lg:col-span-2 group relative p-10 bg-white rounded-[3rem] border border-ink/5 hover:border-primary/20 transition-all duration-500 hover:shadow-2xl hover:shadow-primary/5 reveal-on-scroll stagger-1">
                        <div class="w-16 h-16 rounded-2xl bg-primary/5 text-primary flex items-center justify-center mb-10 group-hover:scale-110 transition-transform duration-500">
                            <iconify-icon icon="lucide:box" class="text-3xl"></iconify-icon>
                        </div>
                        <div class="max-w-lg">
                            <h3 class="font-serif text-3xl text-ink mb-6">Enterprise Design Systems</h3>
                            <p class="text-ink/60 text-lg leading-relaxed mb-10">
                                Import your existing design tokens. We'll ensure every generated component adheres strictly to your spacing, colors, and typography rules.
                            </p>
                            <div class="flex flex-wrap gap-3">
                                <span class="px-4 py-1.5 rounded-full bg-accent text-primary text-[11px] font-bold tracking-tight">tokens.json</span>
                                <span class="px-4 py-1.5 rounded-full bg-accent text-primary text-[11px] font-bold tracking-tight">tailwind.config.js</span>
                                <span class="px-4 py-1.5 rounded-full bg-accent text-primary text-[11px] font-bold tracking-tight">figma-plugin</span>
                            </div>
                        </div>
                        <div class="absolute top-10 right-10 opacity-5 group-hover:opacity-10 transition-opacity">
                            <iconify-icon icon="lucide:box" class="text-9xl"></iconify-icon>
                        </div>
                    </div>

                    <!-- Feature 2 Dark -->
                    <div class="group p-10 bg-ink text-white rounded-[3rem] border border-white/5 hover:-translate-y-2 transition-all duration-500 reveal-on-scroll stagger-2">
                        <div class="w-16 h-16 rounded-2xl bg-white/10 text-primary flex items-center justify-center mb-10 group-hover:rotate-12 transition-all">
                            <iconify-icon icon="lucide:sparkles" class="text-3xl"></iconify-icon>
                        </div>
                        <h3 class="font-serif text-3xl mb-6">AI-Powered Iterations</h3>
                        <p class="text-white/60 text-lg leading-relaxed">
                            "Make it pop." "Less whitespace." "Dark mode." Iterate on designs with simple natural language commands that respect context.
                        </p>
                    </div>

                    <!-- Feature 3 -->
                    <div class="group p-10 bg-white rounded-[3rem] border border-ink/5 hover:-translate-y-2 transition-all duration-500 reveal-on-scroll stagger-3">
                        <div class="w-16 h-16 rounded-2xl bg-accent text-ink flex items-center justify-center mb-10 group-hover:bg-primary group-hover:text-white transition-colors duration-500">
                            <iconify-icon icon="lucide:layout" class="text-3xl"></iconify-icon>
                        </div>
                        <h3 class="font-serif text-3xl text-ink mb-6">Truly Responsive</h3>
                        <p class="text-ink/60 text-lg leading-relaxed">
                            Mobile-first logic built into every generation. Every layout works perfectly across all viewports automatically.
                        </p>
                    </div>

                    <!-- Feature 4 Export -->
                    <div class="lg:col-span-2 group relative overflow-hidden p-10 bg-white rounded-[3rem] border border-ink/5 hover:shadow-2xl hover:shadow-primary/5 transition-all duration-500 reveal-on-scroll stagger-1">
                        <div class="relative z-10">
                            <div class="w-16 h-16 rounded-2xl bg-primary text-white flex items-center justify-center mb-10 shadow-lg shadow-primary/20">
                                <iconify-icon icon="lucide:external-link" class="text-3xl"></iconify-icon>
                            </div>
                            <div class="max-w-md">
                                <h3 class="font-serif text-3xl text-ink mb-6">Universal Export</h3>
                                <p class="text-ink/60 text-lg leading-relaxed">
                                    React, Vue, HTML/CSS, or plain Figma nodes. Your code, your choice. No platform lock-in, just clean output.
                                </p>
                            </div>
                        </div>
                        <div class="absolute right-0 top-0 bottom-0 w-1/3 bg-gradient-to-l from-primary/5 to-transparent group-hover:w-1/2 transition-all duration-700"></div>
                        <iconify-icon icon="lucide:code" class="absolute -bottom-10 -right-10 text-[12rem] text-ink/5 group-hover:text-primary/10 transition-all duration-700"></iconify-icon>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section class="py-32 px-6">
            <div class="max-w-7xl mx-auto relative rounded-[4rem] overflow-hidden bg-primary px-8 py-24 md:py-40 text-center text-white shadow-[0_40px_100px_-15px_rgba(239,70,35,0.4)]">
                <!-- Dot Pattern Overlay -->
                <div class="absolute inset-0 opacity-20"
                     style="background-image: radial-gradient(circle at 2px 2px, white 1px, transparent 0); background-size: 30px 30px;">
                </div>
                <div class="absolute top-0 right-0 w-96 h-96 bg-white/10 blur-[100px] -mr-48 -mt-48"></div>
                
                <div class="relative z-10 max-w-4xl mx-auto space-y-12 reveal-on-scroll">
                    <h2 class="font-serif text-6xl md:text-8xl leading-[0.9] tracking-tight">
                        Ready to design <br /> 10x faster?
                    </h2>
                    <p class="font-sans text-xl md:text-2xl text-white/80 max-w-2xl mx-auto leading-relaxed">
                        Join 10,000+ designers and developers building the future of production interfaces with Superdesign.
                    </p>
                    
                    <div class="flex flex-col sm:flex-row gap-6 justify-center pt-8">
                        <a href="#" id="cta-btn-free" class="group inline-flex items-center justify-center gap-3 px-12 py-6 rounded-full bg-white text-primary font-bold text-xl hover:bg-ink hover:text-white transition-all duration-300 shadow-xl">
                            Get Started for Free
                            <iconify-icon icon="lucide:rocket" class="group-hover:translate-x-1 group-hover:-translate-y-1 transition-transform"></iconify-icon>
                        </a>
                        <a href="#" id="cta-btn-pricing" class="inline-flex items-center justify-center gap-3 px-12 py-6 rounded-full border-2 border-white/30 text-white font-bold text-xl hover:bg-white/10 transition-all duration-300">
                            View Pricing
                        </a>
                    </div>
                    
                    <div class="flex items-center justify-center gap-2 text-sm opacity-60 font-semibold uppercase tracking-widest">
                        <iconify-icon icon="lucide:shield-check"></iconify-icon>
                        No credit card required • Free plan available
                    </div>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer class="bg-ink pt-32 pb-16 px-6 text-white/50">
            <div class="max-w-7xl mx-auto">
                <div class="grid md:grid-cols-2 lg:grid-cols-5 gap-16 mb-24">
                    <div class="lg:col-span-2 space-y-10">
                        <a href="#" id="footer-logo" class="flex items-center gap-3 text-white">
                            <div class="w-8 h-8 bg-primary rounded-lg flex items-center justify-center text-white font-serif italic font-bold text-lg">S</div>
                            <span class="font-serif text-3xl font-bold tracking-tight">Superdesign</span>
                        </a>
                        <p class="max-w-md text-xl leading-relaxed text-white/60">
                            Empowering creative teams to move from idea to reality in seconds. Built for the future of product development.
                        </p>
                        <div class="flex gap-6">
                            <a href="#" id="social-twitter" class="w-12 h-12 rounded-full border border-white/10 flex items-center justify-center text-white hover:bg-primary hover:border-primary transition-all">
                                <iconify-icon icon="lucide:twitter" class="text-xl"></iconify-icon>
                            </a>
                            <a href="#" id="social-github" class="w-12 h-12 rounded-full border border-white/10 flex items-center justify-center text-white hover:bg-primary hover:border-primary transition-all">
                                <iconify-icon icon="lucide:github" class="text-xl"></iconify-icon>
                            </a>
                            <a href="#" id="social-linkedin" class="w-12 h-12 rounded-full border border-white/10 flex items-center justify-center text-white hover:bg-primary hover:border-primary transition-all">
                                <iconify-icon icon="lucide:linkedin" class="text-xl"></iconify-icon>
                            </a>
                        </div>
                    </div>
                    
                    <div class="space-y-8">
                        <h4 class="font-serif text-2xl text-white tracking-tight">Product</h4>
                        <ul class="space-y-5 text-lg">
                            <li><a href="#" id="footer-link-features" class="hover:text-primary transition-colors">Features</a></li>
                            <li><a href="#" id="footer-link-integrations" class="hover:text-primary transition-colors">Integrations</a></li>
                            <li><a href="#" id="footer-link-enterprise" class="hover:text-primary transition-colors">Enterprise</a></li>
                            <li><a href="#" id="footer-link-changelog" class="hover:text-primary transition-colors">Changelog</a></li>
                        </ul>
                    </div>
                    
                    <div class="space-y-8">
                        <h4 class="font-serif text-2xl text-white tracking-tight">Resources</h4>
                        <ul class="space-y-5 text-lg">
                            <li><a href="#" id="footer-link-docs" class="hover:text-primary transition-colors">Documentation</a></li>
                            <li><a href="#" id="footer-link-community" class="hover:text-primary transition-colors">Community</a></li>
                            <li><a href="#" id="footer-link-blog" class="hover:text-primary transition-colors">Design Blog</a></li>
                            <li><a href="#" id="footer-link-help" class="hover:text-primary transition-colors">Help Center</a></li>
                        </ul>
                    </div>

                    <div class="space-y-8">
                        <h4 class="font-serif text-2xl text-white tracking-tight">Company</h4>
                        <ul class="space-y-5 text-lg">
                            <li><a href="#" id="footer-link-about" class="hover:text-primary transition-colors">About</a></li>
                            <li><a href="#" id="footer-link-careers" class="hover:text-primary transition-colors">Careers</a></li>
                            <li><a href="#" id="footer-link-legal" class="hover:text-primary transition-colors">Legal</a></li>
                            <li><a href="#" id="footer-link-contact" class="hover:text-primary transition-colors">Contact</a></li>
                        </ul>
                    </div>
                </div>
                
                <div class="pt-12 border-t border-white/5 flex flex-col md:flex-row justify-between items-center gap-8 text-sm font-medium tracking-wide">
                    <p>© 2024 Superdesign Inc. Handcrafted for the next web.</p>
                    <div class="flex gap-10">
                        <a href="#" id="footer-bottom-privacy" class="hover:text-white transition-colors">Privacy Policy</a>
                        <a href="#" id="footer-bottom-terms" class="hover:text-white transition-colors">Terms of Service</a>
                        <a href="#" id="footer-bottom-cookies" class="hover:text-white transition-colors">Cookie Settings</a>
                    </div>
                </div>
            </div>
        </footer>

    </div>

    <script>
        // Scroll reveal logic
        const observerOptions = {
            threshold: 0.15,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('is-visible');
                }
            });
        }, observerOptions);

        document.querySelectorAll('.reveal-on-scroll').forEach(el => observer.observe(el));

        // Navigation scroll effect
        const nav = document.getElementById('main-nav');
        window.addEventListener('scroll', () => {
            if (window.scrollY > 50) {
                nav.classList.add('scrolled');
            } else {
                nav.classList.remove('scrolled');
            }
        });

        // Mobile menu toggle (simple logic)
        const menuToggle = document.getElementById('mobile-menu-toggle');
        menuToggle.addEventListener('click', () => {
            // Add menu implementation here if needed, but keeping it simple for UI demo
            alert('Mobile menu clicked - Link structure is optimized for mobile touch targets');
        });
    </script>
</body>
</html>
~~~

Please use the above as reference and apply to our context