~~~html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supergreen | Crafting Pure Performance</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Anton&family=Inter:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --forest: #01472e;
            --sage: #ccd5ae;
            --olive: #e9edc9;
            --cream: #fefae0;
            --moss: #a3b18a;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--sage);
            color: var(--forest);
            overflow-x: hidden;
        }

        .font-serif {
            font-family: 'Anton', sans-serif;
        }

        .noise-overlay {
            position: fixed;
            inset: 0;
            pointer-events: none;
            z-index: 9999;
            opacity: 0.04;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.8' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)'/%3E%3C/svg%3E");
        }

        .hero-text {
            font-size: 23vw;
            line-height: 0.75;
            letter-spacing: -0.05em;
        }

        .reveal-up {
            opacity: 0;
            transform: translateY(100px);
            transition: all 1.2s cubic-bezier(0.16, 1, 0.3, 1);
        }

        .reveal-up.active {
            opacity: 1;
            transform: translateY(0);
        }

        @keyframes float {
            0%, 100% { transform: translateY(0) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(5deg); }
        }

        .floating {
            animation: float 6s ease-in-out infinite;
        }

        .floating-delayed {
            animation: float 8s ease-in-out infinite reverse;
        }

        /* Custom scroll behavior */
        .smooth-scroll {
            scroll-behavior: smooth;
        }

        .card-hover-overlay {
            background: rgba(1, 71, 46, 0.3);
            backdrop-filter: blur(2px);
        }
    </style>
</head>
<body class="smooth-scroll">
    <div class="noise-overlay"></div>

    <!-- Navigation -->
    <header class="fixed top-0 left-0 w-full z-50 px-6 md:px-12 py-8 flex items-center justify-between">
        <div class="flex items-center space-x-2 text-2xl font-serif tracking-tight">
            <span class="opacity-40">-</span>
            <span class="uppercase">Supergreen</span>
        </div>

        <nav class="hidden md:flex bg-white/10 backdrop-blur-xl px-2 py-2 rounded-full border border-white/10">
            <a href="#" id="nav-home" class="px-6 py-2 rounded-full text-xs font-bold uppercase bg-[#01472e] text-white transition-all">Home</a>
            <a href="#" id="nav-about" class="px-6 py-2 rounded-full text-xs font-bold uppercase hover:bg-[#01472e]/10 transition-all">About</a>
            <a href="#" id="nav-products" class="px-6 py-2 rounded-full text-xs font-bold uppercase hover:bg-[#01472e]/10 transition-all">Products</a>
            <a href="#" id="nav-shop" class="px-6 py-2 rounded-full text-xs font-bold uppercase hover:bg-[#01472e]/10 transition-all">Shop</a>
            <a href="#" id="nav-contact" class="px-6 py-2 rounded-full text-xs font-bold uppercase hover:bg-[#01472e]/10 transition-all">Contact</a>
        </nav>

        <div class="flex items-center space-x-6 md:space-x-10">
            <span class="hidden lg:block text-sm font-bold tracking-tight">+1 123 456 789</span>
            <div class="bg-white/10 backdrop-blur-md px-5 py-2 rounded-full flex items-center space-x-3 cursor-pointer hover:bg-[#01472e]/10 transition-all border border-[#01472e]/10">
                <span class="text-[10px] font-bold uppercase hidden sm:inline tracking-widest">Cart</span>
                <iconify-icon icon="lucide:shopping-cart" class="text-sm"></iconify-icon>
                <span class="bg-white text-[#01472e] px-1.5 py-0.5 rounded text-[10px] font-bold leading-none min-w-[1.2rem] text-center">0</span>
            </div>
            <button class="md:hidden">
                <iconify-icon icon="lucide:menu" class="text-2xl"></iconify-icon>
            </button>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="relative min-h-screen flex flex-col justify-center items-center px-4 overflow-hidden">
        <!-- Floating Ingredients -->
        <div class="absolute inset-0 pointer-events-none">
            <img src="https://images.unsplash.com/photo-1550989460-0adf9ea622e2?q=80&w=600&auto=format&fit=crop" 
                 alt="Kale" 
                 class="floating absolute top-[15%] left-[-5%] w-64 h-64 md:w-80 md:h-80 object-cover rounded-[3rem] shadow-2xl grayscale-[0.2] opacity-90">
            
            <img src="https://images.unsplash.com/photo-1528498033373-3c6c08e93d79?q=80&w=600&auto=format&fit=crop" 
                 alt="Matcha" 
                 class="floating-delayed absolute bottom-[25%] right-[-5%] w-56 h-56 md:w-72 md:h-72 object-cover rounded-[3rem] shadow-2xl rotate-[-12deg] grayscale-[0.2] opacity-80">
        </div>

        <div class="w-full flex justify-center z-10">
            <h1 class="hero-text font-serif text-[#01472e] select-none text-center whitespace-nowrap animate-[revealUp_1.8s_ease-out] flex">
                <span>S</span><span>U</span><span>P</span><span>E</span><span>R</span><span>G</span><span>R</span><span>E</span><span>E</span><span>N</span>
            </h1>
        </div>

        <div class="absolute bottom-12 w-full px-6 md:px-12 flex flex-col md:flex-row justify-between items-end gap-12 z-10">
            <div class="max-w-md">
                <p class="text-[#01472e] text-2xl md:text-3xl font-medium leading-tight tracking-tight reveal-up">
                    High-performance nutrition compressed into perfectly craveable, plant-powered bites.
                </p>
            </div>
            <div class="flex flex-col items-start md:items-end text-left md:text-right reveal-up">
                <p class="text-[#01472e] text-xs font-bold uppercase tracking-[0.3em] mb-2">
                    Founded in Vancouver, BC
                </p>
                <p class="text-[#01472e] text-sm opacity-60 font-medium">
                    Small Batch • Organic • 100% Vegan
                </p>
            </div>
        </div>

        <div class="absolute bottom-10 left-1/2 -translate-x-1/2 animate-bounce">
            <iconify-icon icon="lucide:arrow-down" class="text-2xl text-[#01472e]/40"></iconify-icon>
        </div>
    </section>

    <!-- Product Section -->
    <section class="bg-[#e9edc9] py-32 px-6 md:px-12 rounded-t-[5rem] relative z-20 -mt-10">
        <div class="max-w-[1440px] mx-auto">
            <div class="flex flex-col md:flex-row justify-between items-start md:items-end mb-24 gap-8">
                <h2 class="font-serif text-[clamp(5rem,15vw,12rem)] leading-[0.85] text-[#01472e] reveal-up">
                    CRAVE<br/>BETTER.
                </h2>
                <a href="#" id="cta-view-all" class="bg-[#01472e] text-white px-12 py-6 rounded-full font-bold uppercase tracking-[0.2em] text-[10px] hover:scale-105 transition-transform inline-block shadow-2xl shadow-[#01472e]/20 reveal-up">
                    View All Snacks
                </a>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-10 lg:gap-16">
                <!-- Product 1 -->
                <div class="group cursor-pointer flex flex-col h-full reveal-up" style="transition-delay: 0.1s">
                    <div class="aspect-[4/5] bg-[#ccd5ae] rounded-[2.5rem] overflow-hidden mb-8 relative shadow-xl isolate">
                        <img src="https://vgbujcuwptvheqijyjbe.supabase.co/storage/v1/object/public/hmac-uploads/uploads/4aed2f49-a476-436f-bae8-f31aa18f46fa/1767955356601-3c056a10/image.png" 
                             alt="Matcha + Hemp" 
                             class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110">
                        <div class="absolute inset-0 card-hover-overlay opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-center justify-center">
                            <button class="bg-white text-[#01472e] px-10 py-4 rounded-full font-bold shadow-2xl translate-y-8 group-hover:translate-y-0 transition-all duration-500 uppercase text-[10px] tracking-widest">
                                Quick Add
                            </button>
                        </div>
                    </div>
                    <div class="flex justify-between items-start px-2">
                        <div>
                            <h3 class="text-3xl font-serif text-[#01472e] tracking-tight">Matcha + Hemp</h3>
                            <p class="text-[#01472e]/60 font-bold uppercase text-[9px] tracking-[0.3em] mt-3">Energy • Sustenance</p>
                        </div>
                        <span class="text-[#01472e] font-serif text-3xl">$14</span>
                    </div>
                </div>

                <!-- Product 2 -->
                <div class="group cursor-pointer flex flex-col h-full reveal-up" style="transition-delay: 0.3s">
                    <div class="aspect-[4/5] bg-[#ccd5ae] rounded-[2.5rem] overflow-hidden mb-8 relative shadow-xl isolate">
                        <img src="https://images.unsplash.com/photo-1590301157890-4810ed352733?q=80&w=600&auto=format&fit=crop" 
                             alt="Goji + Cacao" 
                             class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110">
                        <div class="absolute inset-0 card-hover-overlay opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-center justify-center">
                            <button class="bg-white text-[#01472e] px-10 py-4 rounded-full font-bold shadow-2xl translate-y-8 group-hover:translate-y-0 transition-all duration-500 uppercase text-[10px] tracking-widest">
                                Quick Add
                            </button>
                        </div>
                    </div>
                    <div class="flex justify-between items-start px-2">
                        <div>
                            <h3 class="text-3xl font-serif text-[#01472e] tracking-tight">Goji + Cacao</h3>
                            <p class="text-[#01472e]/60 font-bold uppercase text-[9px] tracking-[0.3em] mt-3">Antioxidant • Power</p>
                        </div>
                        <span class="text-[#01472e] font-serif text-3xl">$16</span>
                    </div>
                </div>

                <!-- Product 3 -->
                <div class="group cursor-pointer flex flex-col h-full reveal-up" style="transition-delay: 0.5s">
                    <div class="aspect-[4/5] bg-[#ccd5ae] rounded-[2.5rem] overflow-hidden mb-8 relative shadow-xl isolate">
                        <img src="https://images.unsplash.com/photo-1620916566398-39f1143ab7be?q=80&w=600&auto=format&fit=crop" 
                             alt="Spirulina Sea Salt" 
                             class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110">
                        <div class="absolute inset-0 card-hover-overlay opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-center justify-center">
                            <button class="bg-white text-[#01472e] px-10 py-4 rounded-full font-bold shadow-2xl translate-y-8 group-hover:translate-y-0 transition-all duration-500 uppercase text-[10px] tracking-widest">
                                Quick Add
                            </button>
                        </div>
                    </div>
                    <div class="flex justify-between items-start px-2">
                        <div>
                            <h3 class="text-3xl font-serif text-[#01472e] tracking-tight">Spirulina Sea Salt</h3>
                            <p class="text-[#01472e]/60 font-bold uppercase text-[9px] tracking-[0.3em] mt-3">Crunchy • Clean</p>
                        </div>
                        <span class="text-[#01472e] font-serif text-3xl">$12</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-[#01472e] text-[#ccd5ae] pt-32 pb-16 px-6 md:px-12 relative z-20">
        <div class="max-w-[1440px] mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-20">
                <div class="lg:col-span-6">
                    <h2 class="font-serif text-[clamp(3.5rem,8vw,6rem)] leading-[0.9] mb-12">
                        Join the green movement.
                    </h2>
                    <div class="flex max-w-md relative group">
                        <input type="email" 
                               placeholder="your@email.com" 
                               class="bg-transparent border-b border-[#ccd5ae]/30 py-6 w-full focus:outline-none focus:border-[#ccd5ae] transition-colors placeholder:text-[#ccd5ae]/30 font-medium pr-24 uppercase text-[10px] tracking-widest">
                        <button class="absolute right-0 bottom-6 font-bold uppercase tracking-[0.2em] text-[10px] hover:text-white transition-colors">
                            Submit
                        </button>
                    </div>
                </div>
                
                <div class="lg:col-span-3 lg:pl-12">
                    <h4 class="font-bold uppercase text-[9px] tracking-[0.4em] mb-12 opacity-40">Explore</h4>
                    <ul class="space-y-6 font-bold text-[11px] uppercase tracking-[0.2em]">
                        <li><a href="#" id="footer-shop" class="hover:text-white transition-colors">Shop Products</a></li>
                        <li><a href="#" id="footer-wholesale" class="hover:text-white transition-colors">Wholesale</a></li>
                        <li><a href="#" id="footer-sustainability" class="hover:text-white transition-colors">Sustainability</a></li>
                        <li><a href="#" id="footer-careers" class="hover:text-white transition-colors">Careers</a></li>
                    </ul>
                </div>

                <div class="lg:col-span-3">
                    <h4 class="font-bold uppercase text-[9px] tracking-[0.4em] mb-12 opacity-40">Follow</h4>
                    <ul class="space-y-6 font-bold text-[11px] uppercase tracking-[0.2em]">
                        <li><a href="#" id="social-ig" class="hover:text-white transition-colors">Instagram</a></li>
                        <li><a href="#" id="social-tw" class="hover:text-white transition-colors">Twitter</a></li>
                        <li><a href="#" id="social-fb" class="hover:text-white transition-colors">Facebook</a></li>
                        <li><a href="#" id="social-tk" class="hover:text-white transition-colors">TikTok</a></li>
                    </ul>
                </div>
            </div>

            <div class="pt-32 border-t border-[#ccd5ae]/10 mt-32 flex flex-col md:flex-row justify-between items-center gap-8 text-[9px] font-bold uppercase tracking-[0.3em] opacity-30">
                <p>&copy; 2024 SUPERGREEN CORP. ALL RIGHTS RESERVED.</p>
                <div class="flex space-x-12">
                    <a href="#" id="footer-privacy" class="hover:text-white transition-colors">Privacy Policy</a>
                    <a href="#" id="footer-terms" class="hover:text-white transition-colors">Terms of Service</a>
                </div>
            </div>
        </div>
    </footer>

    <script>
        // Intersection Observer for scroll animations
        const observerOptions = {
            threshold: 0.1
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('active');
                }
            });
        }, observerOptions);

        document.querySelectorAll('.reveal-up').forEach(el => {
            observer.observe(el);
        });

        // Parallax effect on scroll for floating elements
        window.addEventListener('scroll', () => {
            const scrolled = window.scrollY;
            const floatingImgs = document.querySelectorAll('.floating, .floating-delayed');
            
            floatingImgs.forEach((img, index) => {
                const speed = 0.05 + (index * 0.02);
                const yPos = -(scrolled * speed);
                img.style.transform = `translateY(${yPos}px) rotate(${scrolled * 0.01}deg)`;
            });
        });

        // Stagger hero text loading animation
        document.querySelectorAll('.hero-text span').forEach((span, i) => {
            span.style.display = 'inline-block';
            span.style.opacity = '0';
            span.style.transform = 'translateY(100px) scaleY(1.5)';
            span.style.transition = 'all 1.4s cubic-bezier(0.16, 1, 0.3, 1)';
            span.style.transitionDelay = `${i * 0.05}s`;
            
            setTimeout(() => {
                span.style.opacity = '1';
                span.style.transform = 'translateY(0) scaleY(1)';
            }, 100);
        });
    </script>
</body>
</html>
~~~

This is a reference of nature inspired style. Please implement the style into the current context.